package SOMA.output;

import java.io.*;
import java.awt.*;

public class ListOutputStream extends OutputStream implements Serializable
{
  public List Target;
  private int MaxLines = 500;

  private static final String LineSeparator = System.getProperty( "line.separator" );
  //private static final String LineSeparator = "\n";

  public ListOutputStream( List Target )
  {
    this.Target = Target;
    Target.add( "" );
  }

  public ListOutputStream( List Target, int MaxLines )
  {
    this( Target );
    this.MaxLines = MaxLines;
  }


  public void write(int b) throws IOException
  {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write( b );
    WriteString( Out.toString() );
    Out.close();
  }

  public void write(byte[] b) throws IOException
  {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write( b );
    WriteString( Out.toString() );
    Out.close();
  }

  public void write(byte[] b, int off, int len) throws IOException
  {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write( b, off, len );  // Funzioner?
    WriteString( Out.toString() );
    Out.close();
  }

  private void WriteString( String Str )
  {
    int LastLineIndex = Target.getItemCount() - 1;
    int FromIndex = 0, ToIndex;
    int Length = LineSeparator.length();

    try
    {
      if( (ToIndex = Str.indexOf( LineSeparator ))  < 0 )
        ToIndex = Str.length();

      // Appendo la prima riga all'ultima senza andare a capo.
      Target.replaceItem( Target.getItem(LastLineIndex) +
                          Str.substring(FromIndex,ToIndex), LastLineIndex);

      // Aggiungo le altre righe.
      for( FromIndex = ToIndex + Length;
           (ToIndex = Str.indexOf(LineSeparator,FromIndex)) >= 0; )
      {
        Target.add( Str.substring( FromIndex, ToIndex) );
        FromIndex = ToIndex + Length;
      }

      // L'ultima riga o newline
      if( FromIndex <= Str.length() )
         Target.add( Str.substring(FromIndex, Str.length()) );
    }
    catch( Exception e )
    {
      System.out.println( "!!" + e + "->" + e.getMessage());
      e.printStackTrace();
    }

    while( Target.getItemCount() > MaxLines )
      Target.remove( 0 );

    Target.makeVisible( Target.getItemCount() - 1);
  }
}
