package SOMA.output;

import java.io.*;
import javax.swing.JTextArea;
import javax.swing.JScrollBar;
import java.security.*;

public class JTextAreaOutputStream extends OutputStream implements Serializable
{
  public JTextArea Target;
  public JScrollBar jScrollBar;

  private int MaxLines = 500;

  private static final String LineSeparator = System.getProperty( "line.separator" );
  //private static final String LineSeparator = "\n";

  public JTextAreaOutputStream( JTextArea Target, JScrollBar jScrollBar )
  {
    this.Target = Target;
    this.jScrollBar = jScrollBar;
    //Target.add( "" );
    Target.append( "" );
  }

  public JTextAreaOutputStream( JTextArea Target, JScrollBar jScrollBar, int MaxLines )
  {
    this( Target, jScrollBar );
    this.MaxLines = MaxLines;
  }


  public void write(int b) throws IOException
  {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write( b );
    WriteString( Out.toString() );
    Out.close();
  }

  public void write(byte[] b) throws IOException
  {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write( b );
    WriteString( Out.toString() );
    Out.close();
  }

  public void write(byte[] b, int off, int len) throws IOException
  {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write( b, off, len );  // Funzioner?
    WriteString( Out.toString() );
    Out.close();
  }

  private void WriteString( final String str )
  {
    AccessController.doPrivileged(
        new PrivilegedAction()
        {
          public Object run()
          {
            Target.append( str );

            // Cancello le prime linee se tropp lunga
            int nLines = Target.getLineCount();
            if( nLines > MaxLines )
            {
              try
              {
                Target.replaceRange( "", 0, Target.getLineEndOffset( nLines - MaxLines ) );
              }
              catch( javax.swing.text.BadLocationException e )
              {
                e.printStackTrace();
              }
            }

            // Posizione: la fine.
            if( !jScrollBar.getValueIsAdjusting() )
              jScrollBar.setValue( jScrollBar.getMaximum() );

            return null;
          }
        });
  }
}
