package SOMA.network.connection;

import java.io.*;

import SOMA.Environment;

/** Autoconnessione: esegue in locale i comandi spediti.
* @author Livio Profiri
*/
public class SelfConnection extends Connection
{
  public SelfConnection( Environment env )
  {
    this.env = env;

    status = ON;
  }

  public Object getStatus()
  {
    return status;
  }

  /** Metodo vuoto. */
  public void start() throws ConnectionException
  {}

  /** Metodo vuoto. */
  public synchronized void stop() throws Exception
  {}

  public String toString()
  {
    return "[SelfConnection]";
  }

  /** Esegue il comando. */
  public void send( Command c ) throws IOException, ConnectionException
  {
    //env.out.println( "SelfConnection: autorunning "+ c );
    c.start( this, env );
  }

  /** Metodo vuoto. */
  public void run()
  {}
}