package SOMA.network.connection;

import java.net.*;
import java.io.*;

/** Server in attesa di {@link SOMA.network.connection.Connection connessioni}.
*
* @see SOMA.network.connection.NewServerExplorerItem
*
* @author Livio Profiri
*/
public class ConnectionServer implements Runnable, Daemon
{
  Thread myServerDaemon = null;
  ServerSocket myServerSocket = null;
  ConnectionFactory myConnectionFactory = null;

  Object status = OFF;
  String ErrorDescription = "";

  int port = 0;
  int backlog = 50;

  /** Costruttore.
  * @param port Porta su cui si attendono connessioni.
  * @param backlog Numero massimo di connessioni contemporanee.
  * @param myConnectionFactory Classe responsabile della creazione delle connessioni.
  */
  public ConnectionServer(int port, int backlog, ConnectionFactory myConnectionFactory )
  {
    this.port = port;
    this.backlog = backlog;
    this.myConnectionFactory = myConnectionFactory;
  }

  /** Restituisce lo stato. */
  public Object getStatus()
  {
    return status;
  }

  /** Avvia il server. */
  public synchronized void start() throws IOException, ConnectionServerException
  {
    if( status != ON )
    {
      try
      {
        myServerSocket = new ServerSocket( port, backlog );

        myServerDaemon = new Thread( this, toString() );

        /*
        try
        {
          myServerDaemon.setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        catch( Exception e )
        {
          e.printStackTrace();
        }*/

        status = ON;

        myServerDaemon.start();
      }
      catch( IOException e )
      {
        status = ERROR;
        ErrorDescription = e.toString();
        throw( e );
      }
    }
    else
      throw new ConnectionServerException( "Server already ON" );
  }

  /** Arresta il server. */
  public synchronized void stop() throws IOException, ConnectionServerException
  {
    if( status != OFF )
    {
      try
      {
        status = OFF;

        if( myServerSocket != null )
          myServerSocket.close();

        // Vedo se cos posso riattivarla in seguito.
        myServerSocket = null;
      }
      catch( IOException e )
      {
        status = ERROR;
        ErrorDescription = e.toString();
        throw( e );
      }
    }
    else
      throw new ConnectionServerException( "The server is already OFF" );
  }

  /* Rappresentazione in stringa dello stato del server. */
  public String toString()
  {
    return "[ConnectionServer: socket " + myServerSocket + " status: " + status +
           (status == ERROR ?  " " + ErrorDescription : "") + "]";
  }

  /** Metodo eseguito dal demone: attende richieste ed attiva connessioni finche' lo stato rimane ON e la ServerSocket attiva. */
  public void run()
  {
    Socket aSocket = null;
    Connection aConnection = null;

    while( status == ON )
    {
      try
      {
        //System.out.println( "SERVER " + toString() + " ACCEPT" );
        aSocket = myServerSocket.accept();
        //System.out.println( "SERVER " + toString() + " CREATE CONNECTION" );
        aConnection = myConnectionFactory.createConnection( aSocket );

        aConnection.start();
        //System.out.println( "SERVER " + toString() + " CONNECTION STARTED" );
      }
      catch( Exception e )
      {
        //if( (e instanceof SocketException) && (status == OFF) )
        //  System.err.println( "ConnectionServedDaemon: INTERROTTO" );
        //else
        if( status != OFF )  // Connessione non interrotta volutamente
        {
          //e.printStackTrace( env.err );
          status = ERROR;
          ErrorDescription = e.toString();
        }
      }
    }
  }

  /** Eccezione lanciata da ConnectionServer.*/
  public static class ConnectionServerException extends Exception
  {
    public ConnectionServerException( String  s )
    {
      super( s );
    }
  }
}