package SOMA.network.connection;

import SOMA.Environment;

/** Classe responsabile di creare {@link SOMA.network.connection.Connection connessioni}.
*
* @author Livio Profiri
*/
public class ConnectionFactory
{
  Environment env;

  /** Costruttore.
  * @param env Riferimento all'environment del place: ne ha bisogno ogni connessione creata,
  * per poterlo fornire ai comandi eseguiti.
  */
  ConnectionFactory( Environment env )
  {
    this.env = env;
  }

  /** Crea una connessione con la <code>socket</code> e l'<code>env</code>. */
  public Connection createConnection( java.net.Socket s )
  {
    return new Connection( s, env );
  }
}