package SOMA.network.connection;

import java.net.*;
import java.io.*;

import SOMA.Environment;

/** Demone responsabile delle comunicazioni via socket con un altro place.
* @see SOMA.network.connection.NewClientExplorerItem
*
* @author Livio Profiri
*/
public class Connection implements Daemon, Runnable
{
  Thread myDaemon = null;
  Socket mySocket = null;
  ObjectInputStream myObjectInputStream = null;
  ObjectOutputStream myObjectOutputStream = null;

  //BufferedInputStream bis = null;

  Object status = OFF;

  String ErrorDescription = "";

  Environment env = null;

  /** Costruttore vuoto. */
  protected Connection()
  {}

  /** Costruttore: effettua le inizializzazioni ed apre gli stream della socket.
  * @param mySocket Socket utilizzata per le comunicazioni.
  * @param env Riferimento all'environment del place.
  */
  public Connection( Socket mySocket, Environment env )
  {
    this.mySocket = mySocket;
    this.env = env;
    try
    {
      myObjectOutputStream = new ObjectOutputStream( mySocket.getOutputStream() );
      myObjectInputStream = new ObjectInputStream( mySocket.getInputStream() );
      //bis = new BufferedInputStream( mySocket.getInputStream() );
      //myObjectInputStream = new ObjectInputStream( bis );
    }
    catch( IOException e )
    {
      status = ERROR;
      ErrorDescription = e.toString();
    }
  }

  /** Restituisce l'input stream della socket.*/
  public InputStream getIn()
  {
    return myObjectInputStream;
  }

  /** Restituisce l'output stream della socket.*/
  public OutputStream getOut()
  {
    return myObjectOutputStream;
  }


  /** restituisce lo stato della connessione. */
  public Object getStatus()
  {
    return status;
  }

  // Attenzione: necessariamente non si potr riavviare una connessione gi interrotta.

  /** Avvia il demone in ascolto sull'InputStream della socket. */
  public synchronized void start() throws ConnectionException
  {
    if( status == OFF )
    {
      if( env != null )
      {
        myDaemon = new Thread( env.threadGroup, this, toString() );
        //myDaemon.setPriority( Thread.MAX_PRIORITY );
      }
      else
        myDaemon = new Thread( this, toString() );

      status = ON;
      // Le connessioni sono demoni: la virtual machine si chiude anche se ci sono connessioni attive!
      myDaemon.setDaemon( true );

      // Questo per evitare che le nuove connessioni vengano avviate con
      //   un classloader diverso dal classloader di sistema.
      //
      // Se questo avvenisse si avrebbero conflitti nel caso in cui il
      //   classloader dovesse utilizzare connessioni che avrebbero chiaramente
      //   bisogno di lui per caricare le classi.


      try
      {
        myDaemon.setContextClassLoader(ClassLoader.getSystemClassLoader());
      }
      catch( Exception e )
      {
        e.printStackTrace();
      }

      myDaemon.start();
    }
    else
      throw new ConnectionException( "Connection not OFF" );
  }

  // Attenzione: l'operazione di stop viene eseguita indipendentemente
  // dallo stato attuale della connessione: , ad esempio, possibile
  // arrestare una connessione gi nello stato OFF semplicemente per
  // chiudere le socket aperte.
  /** Arresta il demone: chiude la socket e gli stream aperti, lo stato va a OFF. */
  public synchronized void stop() throws Exception
  {
    try
    {
      myObjectOutputStream.close();
      myObjectInputStream.close();

      mySocket.close();
      status = OFF;
    }
    catch( Exception e )
    {
      status = ERROR;
      ErrorDescription = e.toString();
      throw( e );
    }
  }

  public String toString()
  {
    return "[Connection with" + mySocket + " Status: " + status +
              (status == ERROR ? " " + ErrorDescription : "") + "]";
  }

  /** Spedisce un comando. */  // Synchronized?
  public void send( Command c ) throws IOException, ConnectionException
  {
    if( status != ERROR )
    {
      //System.err.println( "Sending " + c + "..." );

      myObjectOutputStream.writeObject( c );
      //System.err.println( "!!!Sent: " + c );

      myObjectOutputStream.flush();
      //System.err.println( "!!!FLUSHED" );
    }
    else
      throw new ConnectionException( "The connection status is ERROR" );
  }

  /** Metodo eseguito dal demone: attende comandi e li esegue finche' lo stato rimane ON e la socket attiva. */
  public void run()
  {
    while( status == ON )
    {
      try
      {
        /*
        if( env != null )
          env.err.println( Thread.currentThread().toString() + " is waiting for a command: " + toString() );
        else
          System.err.println( Thread.currentThread().toString() + " is waiting for a command: " + toString() );

        //env.err.println( "Il classloader  " + getClass().getClassLoader() );

        */
        /*  Messaggi di debug per il problema del blocco delle comunicazioni nel class loading degli agenti
        while( bis.available() == 0 && status == ON )
        {
          Thread.sleep( 2 * 1000 );

          if( env != null )
            env.out.print( "@" );
          else
            System.out.print( "@" );
        }

        if( env != null )
          env.err.println( "Available: " + bis.available() + "  status " + status );
        else
          System.err.println( "Available: " + bis.available() + "  status " + status );
        */

        Command c = (Command)myObjectInputStream.readObject();

        /*
        if( env != null )
          env.out.println( toString() + "RECEIVED " + c );
        else
          System.out.println( toString() + "RECEIVED " + c );*/

        // Parametri: conneciton e environnment
        c.start( this, env );
        //env.out.println( toString() + "STARTED " + c );
        //Thread.yield();  // Aggiunto...
      }
      catch( EOFException e )  // Chiusa la connessione all'altro capo.
      {
        status = OFF;
      }
      catch( SocketException e )  // Chiusa la connessione all'altro capo.
      {
        status = OFF;
      }
      catch( IOException e )  // Altri errori
      {
        status = ERROR;
        ErrorDescription = e.toString();
        e.printStackTrace( env.err );
      }
      catch( Exception e )
      {
        // Catturo anche i possibili errori a runtime (?) lanciati dall'esecuzione del comando.
        // Non vado nello stato di errore.
        e.printStackTrace( env.err );

        // Forse si dovr cambiare eccezione!
        //if( status == OFF )
          //env.err.println( "Connection: " + toString() + " INTERROTTA" );
        //else
        /*
        if( status != OFF )  // Connessione non interrotta volutamente
        {
          //e.printStackTrace( env.err );

          // cerco di isolare gli errori dovuti alla serializzazione
          //   in questi casi non chiudo la connessione
          if( !(e instanceof ObjectStreamException ||
                e instanceof ClassNotFoundException))
          {
            status = ERROR;
            ErrorDescription = e.toString();
          }
        }*/
      }
    }
  }
}