package SOMA.network;

import SOMA.naming.PlaceID;
import SOMA.network.connection.*;

/** Comando per le comunicazioni fra place di domini diversi.
* <BR><BR>
* TransportCommand incapsula il comando da recapitare:
* viene spedito verso una destinazione intermedia, raggiunta la quale
* spedisce di nuovo il comando trasportato.
*
* @author Livio Profiri
*/
public class TransportCommand extends Command
{
  /** @serial*/
  PlaceID destination;
  /** @serial*/
  Command command;

  /** Costruttore.
  * @param destination Place di destinazione.
  * @param command Comando da trasportare.
  */
  public TransportCommand( PlaceID destination, Command command )
  {
    this.destination = destination;
    this.command = command;
  }

  /** Spedisce di nuovo il comando trasportato.
  * <BR><BR>
  * Se c'e' un errore nella spedizione e
  * {@link SOMA.network.connection.Command#startOnError() Command.startOnError()}
  * restituisce <code>true</code>, il comando viene attivato, altrimenti viene perso.
  */
  public void run()
  {
    //env.out.println( "TransportCommand.run: NOW " + env.placeID );
    //env.out.println( "TransportCommand.run: DESTINATION " + destination );

    if( !env.networkManager.sendCommand( destination, command ) )
      //env.out.println( "TransportCommand.run: COMMAND " + command + " SENT!" );
    //else
    {
      if( command.startOnError() )
      {
        env.out.println( "TransportCommand.run: ERROR: Cannot send " + command + "--> EXECUTING HERE!" );
        // Avvio qui il comando con lo stesso environment che ho io
        command.start( ReturnConnection, env );
      }
      else
        env.out.println( "TransportCommand.run: ERROR --> COMMAND " + command + " LOST!" );
    }
  }
}
