package SOMA.network;

import SOMA.naming.PlaceID;
import SOMA.network.connection.*;

/** Comando che termina una connessione stabile fra place se non e' piu' in uso.
*
* @author Livio Profiri
*/
public class StopConnectionCommand extends Command
{
  /** @serial*/
  PlaceID Source;

  /** Costruttore. */
  public StopConnectionCommand( PlaceID Source )
  {
    this.Source = Source;
  }

  /** Se la connessione non  pi in uso, la elimina dal {@link SOMA.network.NetworkManager#connectionStore connectionStore},
  * e fa lo stesso nell'altro pari spedendo un {@link StopConnectionCommand.RemoveConnectionCommand}
  */
  public void run()
  {
    //if( env.networkManager.isPermanentConnection( Source ) > 0 )
    //  env.out.println( "StopConnectionCommand: CONNECTION STILL IN USE: " + Source + " <--> " + env.placeID );
    //else
    if( env.networkManager.isPermanentConnection( Source ) <= 0 )
    {
      //env.out.println( "StopConnectionCommand: STOPPING CONNECTION: " + Source + " <--> " + env.placeID );

      // La rimozione della connessione va fatta in entrambi i domini,
      // la connessione deve essere interrotta solo da un capo.
      try
      {
        ReturnConnection.send( new RemoveConnectionCommand( env.placeID ) );
        ReturnConnection.stop();
      }
      catch( Exception e )
      {
        e.printStackTrace( env.out );
      }

      env.networkManager.connectionStore.removeConnection( Source );
    }
  }

  public String toString()
  {
    return "[StopConnectionCommand: " + Source + "]";
  }


  /** Comando che elimina dal
  * {@link SOMA.network.NetworkManager#connectionStore connectionStore}
  * la connessione attuale.
  *
  * @author Livio Profiri
  */
  public static class RemoveConnectionCommand extends Command
  {
    /** @serial*/
    PlaceID Source;

    /** Costruttore. */
    public RemoveConnectionCommand( PlaceID Source )
    {
      this.Source = Source;
    }

    /** Elimina dal {@link SOMA.network.NetworkManager#connectionStore connectionStore}
    * la connessione attuale.
    */
    public void run()
    {
      env.networkManager.connectionStore.removeConnection( Source );
    }

    public String toString()
    {
      return "[RemoveConnectionCommand: " + Source + "]";
    }
  }
}
