package SOMA.network;

import java.io.*;
import java.util.*;

import SOMA.network.connection.*;
import SOMA.naming.*;

/** Calsse che memorizza le
* {@link SOMA.network.connection.Connection connessioni}
* fra place dello stesso dominio.
*/
public class ConnectionStore
{
  private Hashtable connectionsTable = new Hashtable();

  public Connection getConnection( PlaceID placeID )
  {
    return (Connection)connectionsTable.get( placeID );
  }

  public Connection putConnection( PlaceID placeID, Connection connection )
  {
    Connection old = (Connection)connectionsTable.put( placeID, connection );

    if( old != null && old.getStatus() == Daemon.ON )
    {
      System.err.println( "NetworkManager.putConnection: ATTENZIONE: sto sostituendo una connessione attiva:" );
      System.err.println( "  VECCHIA " + old );
      System.err.println( "  NUOVA " + connection );
      try
      {
        old.stop();
      }
      catch( Exception e )
      {
        e.printStackTrace();
      }
    }

    return old;
  }

  public Connection removeConnection( PlaceID placeID )
  {
    Connection old = (Connection)connectionsTable.remove( placeID );

    if( old != null && old.getStatus() == Daemon.ON )
    {
      System.err.println( "NetworkManager.removeConnection: ATTENZIONE: sto cancellando una connessione attiva:" );
      System.err.println( "  " + old );
      try
      {
        old.stop();
      }
      catch( Exception e )
      {
        e.printStackTrace();
      }
    }

    return old;
  }

  public void closeAllConnections()
  {
    Iterator i = connectionsTable.entrySet().iterator();
    for( int j = 1; i.hasNext(); j++ )
    {
      Map.Entry e = (Map.Entry)i.next();
      i.remove(); // Rimuovo la connessione

      try
      {
        ((Connection)e.getValue()).stop();
      }
      catch( Exception f )
      {
        f.printStackTrace();
      }

      removeConnection( (PlaceID)e.getKey() );
    }
  }

  public void printConnections( PrintStream out )
  {
    Iterator i = connectionsTable.entrySet().iterator();
    for( int j = 1; i.hasNext(); j++ )
    {
      Map.Entry e = (Map.Entry)i.next();
      out.println( "  " + j + ") " + e.getKey() + " --> " + e.getValue() );
    }
  }
}