package SOMA.naming.place;

import SOMA.naming.*;
import SOMA.network.connection.Command;

/** Comando di eliminazione di un place da un {@link PlaceNameService PNS}.
*
* @author Livio Profiri
*/
public class RemovePlaceCommand extends Command
{
  /** @serial*/
  PlaceID toRemove;

  /** Costruttore. */
  public RemovePlaceCommand( PlaceID toRemove )
  {
    this.toRemove = toRemove;
    System.out.println( toString() + " created " );
  }

  /** Rimuove il place. */
  public void run()
  {
    env.placeNameService.removePlace( toRemove );

    env.out.println( toString() + " Completed!" );
  }

  public String toString()
  {
    return "[RemovePlaceCommand " + toRemove + "]";
  }
}
