package SOMA.naming.place;

import SOMA.naming.*;
import SOMA.network.connection.Command;

/** Comando di aggiornamento di un {@link PlaceNameService PNS}.
*
* <P>Viene aggiunto o modificato un place.
*
* @author Livio Profiri
*/
public class PutPlaceCommand extends Command
{
  // Attenzione: funziona sia per place aggiunti, che per place modificati.
  /** @serial*/
  PlaceInfo toPut;

  /** Costruttore. */
  public PutPlaceCommand( PlaceInfo toPut )
  {
    this.toPut = toPut;
    System.out.println( toString() + " created " );
  }

  /** Aggiunge o modifica il place. */
  public void run()
  {
    env.placeNameService.putPlace( toPut );

    env.out.println( toString() + " Completed!" );
  }

  public String toString()
  {
    return "[PutPlaceCommand " + toPut + "]";
  }
}

