package SOMA.naming.place;

import SOMA.naming.*;
import SOMA.network.connection.Command;

import java.util.Hashtable;

/** Comando di registrazione del {@link PlaceNameService PNS} di un place presso il PNS del default place.
*
* @author Livio Profiri
*/
public class PlaceRegisterCommand extends Command
{
  /** @serial*/
  protected PlaceInfo myPlaceInfo;

  /** Costruttore */
  public PlaceRegisterCommand ( PlaceInfo myPlaceInfo )
  {
    this.myPlaceInfo = myPlaceInfo;
    System.out.println( "Register command " + myPlaceInfo + " created " );
  }

  /** Registra il place e gli spedisce un {@link PlaceRefreshCommand}.
  *
  * <P> Se un place con lo stesso nome era gia' presente, gli viene spedito un messaggio di errore.
  */
  public void run()
  {
    env.out.println( "Register command " + myPlaceInfo + " running " );
    //env.out.println( "Environment: " + env );

    // Verifico che non sia gi presente il nome
    //   e che sia nello stesso dominio!
    if( myPlaceInfo.placeID.sameDomain( env.placeID ) &&
        env.placeNameService.getPlace( myPlaceInfo.placeID ) == null )
    {
       env.placeNameService.putPlace( myPlaceInfo );
       env.networkManager.connectionStore.putConnection( myPlaceInfo.placeID, ReturnConnection ); //!!!!!!!!!!!!!!!!!!!!!
       //Return( new PlaceRefreshCommand( env.placeNameService.places, env.placeID ));
       Return( new PlaceRefreshCommand( env ));
    }
    else
    {
      Return( new Command()
        {
          public void run()
          {
            env.err.println( "ERROR: Can't register place " + myPlaceInfo );
            try
            {
              ReturnConnection.stop();
            }
            catch( Exception f )
            {
              f.printStackTrace( env.err );
            }
          }
        });

      env.err.println( "ERROR: Place " + myPlaceInfo + " already exists!" );
    }
  }
}