package SOMA.mobilePlace;

import SOMA.naming.*;

/** Identificatore di un {@link SOMA.Environment place} mobile.
*
* @author Livio Profiri
*/
public class MobilePlaceID extends PlaceID
{
  /** Questo prefisso viene aggiunto per indicare che si tratta di un place mobile.*/
  public static final String PREFIX = "(M) ";

  /** Costruisce un identificatore a partire dalle sue componenti. */
  public MobilePlaceID( String domain, String place )
  {
    super( domain, place );

    if( place.equals( "" ) )
      throw new RuntimeException( "MobilePlaceID: ("+ domain + ") Can't create a mobile default place!" );
  }

  /** Costruisce l'ID di un place mobile a partire dall'ID di un place fisso.
  */
  public MobilePlaceID( PlaceID placeID )
  {
    this( placeID.domain, placeID.place );
  }

  /** Costruisce un identificatore a partire da una stringa.
  * <BR> E' l'inversa di {@link #toString()}.
  */
  public MobilePlaceID( String s ) throws NameException
  {
    super( removePrefix( s ) );

    if( isDomain() )
      throw new RuntimeException( "MobilePlaceID: ("+ domain + ") Can't create a mobile default place!" );
  }

  /** Restituisce l'Home Domain del place mobile.
  */
  public PlaceID getHome()
  {
    return getDomainID();
  }

  /** Rimuove il prefisso {@link #PREFIX} dalla stringa di descrizione di un placeID.
  */
  public static String removePrefix( String s )
  {
    if( isMobile( s ) )
      return s.substring( PREFIX.length() ).trim();
    else
      return s;
  }

  /** Testa se il prefisso {@link #PREFIX} precede la stringa di descrizione di un placeID.
  */
  public static boolean isMobile( String s )
  {
    return s.startsWith( PREFIX );
  }

  /** In base alla presenza o meno del prefisso costruisce un PlaceID o un MobilePlaceID.
  */
  public static PlaceID parsePlaceID( String s ) throws NameException
  {
    if( isMobile( s ) )
      return new MobilePlaceID( s );
    else
      return new PlaceID( s );
  }

  /** Rappresentazione dell'identificatore sotto forma di stringa.
  * <BR> E' l'inversa di {@link #MobilePlaceID(String s) PlaceID(String s)}.
  */
  public String toString()
  {
    return PREFIX + domain + " " + place;
  }

}