package SOMA.mobilePlace;

import SOMA.naming.*;
import SOMA.naming.place.*;
import SOMA.network.connection.*;

import java.util.Hashtable;

/** Comando di registrazione del {@link MobilePlaceNameService PNS} di un place mobile presso il PNS del default place.
*  nel caso di somasecurity
*
* @author Angelo Colantonio
*/
public class MobilePlaceConnectionCommandSecurity extends Command
{
  PlaceInfo myPlaceInfo;

  /** Costruttore */
  public MobilePlaceConnectionCommandSecurity( PlaceInfo myPlaceInfo )
  {
    this.myPlaceInfo = myPlaceInfo;
  }

  public void run()
  {
    // Sarebbe opportuno aggiungere una procedura di controllo di sicurezza.

    // Comunicare posizione ad interessato e alla Home
    //   env.mobilePlaceManager.putPosition( myPlaceInfo.placeID, env.placeID );

    // Vedi PlaceRegisterCommand

    env.placeNameService.putPlace( myPlaceInfo );

    PlaceID mobilePlaceID = myPlaceInfo.placeID;
    PlaceID homePlaceID = ((MobilePlaceID)mobilePlaceID).getHome();

    env.networkManager.connectionStore.putConnection( mobilePlaceID, ReturnConnection ); //!!!!!!!!!!!!!!!!!!!!!
    env.networkManager.sendCommand( mobilePlaceID, new PlaceRefreshCommand( env ));

    // Aggiorno la posizione del place mobile sul place mobile
    env.networkManager.sendCommand( mobilePlaceID,
        new UpdateMobilePlacePositionCommand( env.placeID ) );

    // Aggiorno la posizione del place mobile sulla home
    env.networkManager.sendCommand( homePlaceID,
        new UpdateHomePositionCommand( mobilePlaceID, env.placeID ) );
  }

  public static class UpdateHomePositionCommand extends Command
  {
    PlaceID mobilePlaceID;
    PlaceID actualDomainID;

    UpdateHomePositionCommand( PlaceID mobilePlaceID, PlaceID actualDomainID )
    {
      this.mobilePlaceID = mobilePlaceID;
      this.actualDomainID = actualDomainID;
    }

    public void run()
    {
      env.mobilePlaceManager.putPosition( mobilePlaceID, actualDomainID );
      env.out.println( "HOME - Mobile Place: " + mobilePlaceID + " joined domain: " + actualDomainID );

      if( !actualDomainID.equals( MobilePlaceManager.DISCONNECTED ) )
        env.mobilePlaceManager.sendWaitingAgents( mobilePlaceID );
    }
  }

  public static class UpdateMobilePlacePositionCommand extends QuickCommand
  {
    PlaceID actualDomainID;

    UpdateMobilePlacePositionCommand( PlaceID actualDomainID )
    {
      this.actualDomainID = actualDomainID;
    }

    public void run()
    {
      ((MobileSecurityEnvironment)env).currentDomainID = actualDomainID;   // attenzione qui il cast
      env.out.println( "Mobile Place: " + env.placeID + " joined domain: " + actualDomainID );
    }
  }
}