package SOMA.mobilePlace;

import SOMA.*;
import SOMA.naming.*;
import SOMA.naming.domain.*;
import SOMA.naming.place.*;
import SOMA.explorer.*;

import java.io.*;
import java.net.*;
import java.util.Collection;

/*
// Ecco dove trovare le classi degli oggetti
//   che compongono il sistema
import SOMA.network.NetworkManager;
import SOMA.explorer.DirExplorerItem;
import SOMA.naming.PlaceID;
import SOMA.naming.domain.DomainNameService;
import SOMA.naming.place.PlaceNameService;
import SOMA.agent.mobility.AgentManager;
import SOMA.output.PlaceWindow;
import SOMA.agent.AgentWorker;

import java.io.*;
import SOMA.explorer.*;
import SOMA.network.connection.*;
import SOMA.naming.*;
*/

/** Classe che rappresenta l'astrazione di place mobile.
*
* @author Livio Profiri
*/

public class MobileEnvironment extends Environment
{
  /** Dominio a cui il place mobile  connesso. */
  public PlaceID currentDomainID = MobilePlaceManager.DISCONNECTED;

  /** Costruttore: avvia il place mobile chiamando il costruttore del place normale, aggiungendo poi altre cose.
  *
  * <P> I final servono solo per poter utilizzare delle classi anonime.
  */
  public MobileEnvironment( final PlaceID placeID, final DirExplorerItem dir, final int port,
                      final InputStream in, final PrintStream out, final PrintStream  err )
    throws Exception
  {
    super( placeID, dir, port, in, out, err );

    if( ! (placeID instanceof MobilePlaceID) )
    {
      out.println( "**** WARNING: Mobile Place " + this + " created with a non mobile PlaceID." );
    }

    dir.addItem( "currentDomain", new ObjectExplorerItem( currentDomainID )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          return currentDomainID;
        }

        public String getSyntax()
        {
          return currentDomainID.toString();
        }
      });

    dir.addItem( "connect", new ExplorerItem( "<DomainID>" )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          PlaceID domainID = new PlaceID( (String)Parameters.iterator().next(), "" );

          out.println( "Connecting to domain: " + domainID );

          connect( domainID );

          return null;
        }
      } );

    dir.addItem( "disconnect", new ExplorerItem( "disconnects mobile place from the current domain." )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          disconnect();

          return null;
        }
      } );
  }

  protected void createNameServices()
  {
    domainNameService = new DomainNameService( this );
    dir.addItem( "dns", new DNSExplorerItem( domainNameService ) );

    placeNameService = new MobilePlaceNameService( this );
    dir.addItem( "pns", new PNSExplorerItem( placeNameService ) );
  }

  public void connect( PlaceID domainID )
  {
    if( currentDomainID.equals( MobilePlaceManager.DISCONNECTED ) )
    {
      try
      {
        // Aggiorno l'indirizzo attuale, nel caso in cui queso sia cambiato.
        networkManager.placeInfo = new PlaceInfo( placeID, SOMA.utility.GetLocalHost.getCurrentLocalHost( out ), networkManager.placeInfo.port );
      }
      catch( UnknownHostException e )
      {
        e.printStackTrace( out );
      }

      // Elimina tutti i place e aggiorna il placeInfo attuale.
      ((MobilePlaceNameService)placeNameService).clear();

      //networkManager.startPermanentConnection( domainID );

      DomainInfo di = domainNameService.getDomain( domainID );

      if( di != null )
      {
        if( networkManager.sendCommand( di.host, di.port,
              new MobilePlaceConnectionCommand( networkManager.placeInfo ) ) )
          out.println( "MobilePlaceConnectionCommand sent!" );
        else
          out.println( "ERROR: MobilePlaceConnectionCommand NOT sent!" );
      }
      else
        out.println( "I don't know domain: " + domainID );
    }
    else
      out.println( "Mobile place ALREADY CONNECTED to " + currentDomainID );
  }

  /** Disconnessione del Place Mobile. */
  public void disconnect()
  {
    if( !currentDomainID.equals( MobilePlaceManager.DISCONNECTED ) )
    {
      networkManager.sendCommand( currentDomainID,
        new MobilePlaceDisconnectionCommand( networkManager.placeInfo.placeID ) );

      currentDomainID = MobilePlaceManager.DISCONNECTED;

      //networkManager.stopPermanentConnection( currentDomainID );

      networkManager.connectionStore.closeAllConnections();

      // Elimina tutti i place.
      ((MobilePlaceNameService)placeNameService).clear();

      out.println( "Disconnection perforomed." );
    }
    else
      out.println( "Mobile place ALREADY DISCONNECTED!" );
  }

  public String toString()
  {
    return "[Mobile " + super.toString() + " --> " + currentDomainID + "]";
  }
}