/**  LinguaGui
 *     Parte di interfaccia grafica per far scegliere all'utente la
 *     lingua da usare.
 *     Prima di usare questa classe occorre aver gi impostato una
 *     lingua da usare (usare la {@link SOMA.lingua.Lingua#defLingua()}).
 *     @see SOMA.lingua.Lingua
 *     @author     Luigi Antenucci
 *     @version    3.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui.lingua;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class LinguaGui {

  // Costanti private:
  protected static final String ICONA_SCEGLI  = "Choose.gif";
  protected static final String BIGIMG_SCEGLI = "ChooseBig.gif";

  // Variabili private:
  protected static boolean PrimaVolta = true;

      /**
       *  Metodo interno per caricare i file di lingua di LinguaGui.
       *  Nota: anche questa classe ha un suo file di lingua
       *  (infatti deve comunicare con l'utente)!
       */
  protected static void CaricaMiaLingua () {
    if (PrimaVolta) {
      Lingua.caricaFileDiLingua (LinguaGui.class);
      // NB: ANCHE QUESTA CLASSE HA UN SUO FILE DI LINGUE!
      PrimaVolta=false;
    }
  } //CaricaMiaLingua

      /**
       *  Apre la finestra che permette all'utente di scegliere una lingua.
       *  Una volta scelta la lingua, viene automaticamente invocato {@link SOMA.lingua.Lingua#defLingua()}
       *  che provveder a generare un evento di "cambioLingua" se necessario.
       */
  public static void finestraSceltaLingua () {
    finestraSceltaLingua (null);
  } //finestraSceltaLingua

      /**
       *  Analoga alla {@link SOMA.lingua.LinguaGui#finestraSceltaLingua()} ma
       *  la finestra che viene aperta sar "modale" al "frameGenitore" passato.
       */
  public static void finestraSceltaLingua (JFrame frameGenitore) {
    // Apre una finestra "dialog" (modale) in cui permette all'utente 
    // di scegliere la lingua da usare.
    // Una volta scelta, invoca automaticamente la "defLingua".
    if (PrimaVolta) 
      CaricaMiaLingua ();  // NB: ANCHE QUESTA CLASSE HA UN SUO FILE DI LINGUE!

    String[] arrImg  = Lingua.cheImgLingue();
    ImageIcon[] arrLingue = new ImageIcon [arrImg.length];
    for (int i=0; i < arrImg.length; i++)
      arrLingue[i] = new ImageIcon(Lingua.LINGUA_PACKAGE_IMG+arrImg[i]);

    ImageIcon iconetta = new ImageIcon(Lingua.LINGUA_PACKAGE_IMG+BIGIMG_SCEGLI);
    int lingAtt = Lingua.cheLinguaAttuale();
    int L = JOptionPane.showOptionDialog 
                 (frameGenitore,
                 Lingua.frase("LINGUAGUI_CHOOSE_LANG"),
                 Lingua.frase("LINGUAGUI_DEF_LANG"),
                 JOptionPane.DEFAULT_OPTION,
                 JOptionPane.QUESTION_MESSAGE,
                 iconetta,
                 // le opzioni sono le stringhe delle lingue
                 arrLingue,
                 // evidenzio (ma NON seleziono) quella attualmente in uso
                 arrLingue[lingAtt]);
    if ((L >= 0) && (L < arrLingue.length))
      Lingua.defLingua (L);
  } //finestraSceltaLingua

      /**
       *  Rende un oggetto {@link javax.swing.JMenu} che, una volta inserito in
       *  una finestra {@link javax.swing.JFrame}, permette all'utente di
       *  cambiare la lingua in modo "dinamico".
       *  Il men contiene dei bottoni "radio" (uno per ogni lingua) e una voce
       *  che invoca la {@link SOMA.lingua.LinguaGui#finestraSceltaLingua()}.
       *  La selezione di un bottone "radio" causa la chiamata a {@link SOMA.lingua.Lingua#defLingua()}.
       */
  public static JMenu menuSceltaLingua () {
    return menuSceltaLingua (null);
  } //menuSceltaLingua

      /**
       *  Analoga alla {@link SOMA.lingua.LinguaGui#menuSceltaLingua()}.
       *  Il {@link javax.swing.JFrame} serve per quando si va ad aprire la
       *  finestra di dialogo per la scelta della lingua.
       */
  public static JMenu menuSceltaLingua (final JFrame frameGenitore) {
    if (PrimaVolta)
      CaricaMiaLingua ();

    String Mnemonici = Lingua.frase("LINGUAGUI_MNEMONICS") + "     ";
    String[] arrLingue = Lingua.cheElencoLingue();
    String[] arrIcone  = Lingua.cheIcoLingue();
    int LAtt = Lingua.cheLinguaAttuale();
    JMenu scelta = new JMenu (Lingua.frase("LINGUAGUI_VOCE_MENU"));
    scelta.setMnemonic(Mnemonici.charAt(0));
    ActionListener mioListCambio = new ActionListener() {
                                          public void actionPerformed(ActionEvent e) {
                                            Lingua.defLingua (e.getActionCommand());
                                          }};
    ButtonGroup gruppo = new ButtonGroup();     // Mi serve un gruppo di bottoni
    JRadioButtonMenuItem item;
    for (int i=0; i < arrLingue.length; i++) {
      item = new JRadioButtonMenuItem (arrLingue[i]);
      item.setIcon (new ImageIcon(Lingua.LINGUA_PACKAGE_IMG+arrIcone[i]));
      item.setSelected (i == LAtt);
      item.setActionCommand(arrLingue[i]);
      item.addActionListener (mioListCambio);
      gruppo.add (item);
      scelta.add (item);
    } //for

    scelta.addSeparator();

    JMenuItem item2 = new JMenuItem (Lingua.frase("LINGUAGUI_VOCE_SCEGLI"));
    item2.setIcon (new ImageIcon(Lingua.LINGUA_PACKAGE_IMG+ICONA_SCEGLI));
    item2.setMnemonic(Mnemonici.charAt(1));
    item2.setAccelerator (KeyStroke.getKeyStroke(KeyEvent.VK_L, ActionEvent.CTRL_MASK));   // CTRL-L
    item2.setActionCommand("");
    item2.addActionListener ( new ActionListener() {
                                public void actionPerformed(ActionEvent e) {
                                    SwingUtilities.invokeLater (new Runnable () {
                                            public void run () {
                                              finestraSceltaLingua (frameGenitore);
                                            } //run
                                    }); //invokeLater
                                }} );
    scelta.add (item2);
    return scelta;   // Rende la voce di men
  } //menuSceltaLingua

} //LinguaGui