/**  TextFieldInputStream2
 *     Pannello per mostrare e usare un InputStream.
 *     Ho preso spunto da quanto fatto da Livio in "SOMA.output.TextFieldInputStream", ma
 *     stavolta uso - giustamente - una JTextField e non una TextField (dell'AWT)!
 *     @author     Luigi Antenucci (dopo Livio Profiri)
 *     @version    2.2
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class TextFieldInputStream2 extends InputStream implements Serializable {

      /**
       *  Il JTextField a cui si fa riferimento per leggere lo stream di input
       */
  private JTextField textField;

      /**
       *  In realt user questo input-stream!
       */
  private transient ByteArrayInputStream in;

  private String    inputBuffer = "";

      
      /**
       *  Costruttore.
       */
  public TextFieldInputStream2 (JTextField textField) {
    this.textField = textField;

    in = new ByteArrayInputStream (new byte[0]);

		textField.addActionListener (new TextFieldListener());
  }

	private void readObject (ObjectInputStream stream) throws IOException, ClassNotFoundException {
    // Questo metodo  chiamato durante la deserializzazione
    stream.defaultReadObject();
    in = new ByteArrayInputStream (new byte[0]);
  } //readObject

  private void writeObject (ObjectOutputStream stream) throws IOException {
    // Questo metodo  chiamato durante la serializzazione
    byte[] buffer = new byte[in.available()];
    // Rimetto i bytes non ancora letti dentro il buffer.
    in.read(buffer);
    inputBuffer = new String(buffer) + inputBuffer;
    stream.defaultWriteObject();
  } //writeObject


  public synchronized int read () throws IOException {
    while (in.available() == 0)
      PrepareIn();
	  int intRead = in.read();

    notifyAll();

    return intRead;
  } //read

  public synchronized int read (byte[] b) throws IOException {
    while (in.available() == 0)
      PrepareIn();
    int retInt = in.read(b);

    notifyAll();

    return retInt;
  } //read

  public synchronized int read(byte[] b, int off, int len) throws IOException {
	  while (in.available() == 0)
      PrepareIn();
    int retInt = in.read( b, off, len);

    notifyAll();

    return retInt;
  } //read

  public int available () throws IOException {
    return in.available();
  } //available

	private synchronized void PrepareIn () {
    if (inputBuffer.equals( "" ))
      try {
        wait(); 
      }
      catch (Exception e) { }
    else {
      try {
        in.close();
      } 
      catch (IOException e) {}
      in = new ByteArrayInputStream (inputBuffer.getBytes());
      inputBuffer = "";
    }
  } //PrepareIn


	class TextFieldListener implements ActionListener, Serializable {

    public synchronized void actionPerformed (ActionEvent event) {
      synchronized (TextFieldInputStream2.this) {
		     inputBuffer = inputBuffer + textField.getText() + System.getProperty("line.separator");
         TextFieldInputStream2.this.notifyAll();
  		   textField.setText ("");
      }
    } //actionPerformed
	} //TextFieldListener (class)

} //TextFieldInputStream2