/**  Pannello
 *     Pannello generico a cui pu essere segnalato un "cambio di lingua".
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.*;

import java.io.Serializable;
import javax.swing.JPanel;


public abstract class Pannello extends JPanel implements LinguaListener {

      /**
       *  Costruisco un pannello place i cui campi sono inizializzati coi dati del place passato.
       *  NOTA: Pannello eredita da JPanel!
       */
  public Pannello () {
    super ();
    Lingua.caricaFileDiLingua (this);  // Carica i file di lingua per l'EREDE (NON PER SE STESSO!)
  } //costruttore

      /**
       *  ASTRATTA! Parte di costruzione del pannello;
       *  Ogni implementazione di questo metodo deve aggiungere oggetti grafici al pannello.
       *  Dopo aver creato gli oggetti con le frasi nulle (per esempio i JLabel e i JButton)
       *  DEV'ESSERE invocata la "impostaFrasi".
       *  Al termine di tutto va invocato il metodo "FineCostruisciPannello".
       *  NOTA: Pannello eredita da JPanel!
       */
  public abstract void costruisciPannello ();

      /**
       *  Fine della costruzione del pannello.
       *  Dev'essere SEMPRE invocata alla fine della propria "costruisciPannello".
       *  Serve per mettersi in ascolto di eventi di cambio lingua.
       */
  protected void FineCostruisciPannello () {
    // SI REGISTRA SUL CAMBIO DI LINGUA
    Lingua.addLinguaListener (this);
  } //FineCostruisciFinestra

      /**
       *  Permette la distruzione del pannello.
       *  Serve per rimuovere il pannello dai "listener" del cambio di lingua.
       */
  public void distruggimi () {
    Lingua.removeLinguaListener (this);
  } //distruggimi

      /**
       *  Permette la disabilitazione degli elementi contenuti nel pannello.
       *  Ogni sottoclasse interessata pu sovrascrivere questo metodo, che qui NON FA NULLA!
       */
  public void disabilitami () {
    // Che fo?, resto o men vado?
  } //disabilitami

      /**
       *  Permette la riabilitazione degli elementi contenuti nel pannello (dopo una "disabilitami").
       *  Ogni sottoclasse interessata pu sovrascrivere questo metodo, che qui NON FA NULLA!
       */
  public void abilitami () {
    // Resto, resto!
  } //abilitami

      /**
       *  ASTRATTA! 
       *  Deve definire/modificare tutte le frasi mostrate nel pannello.
       *  Dev'essere invocata dalla "costruisciPannello" (per assegnare una frase
       *  agli oggetti GIA' CREATI che tengono una stringa).
       *  In essa si fanno invocazioni del tipo:
       *      <code>  OGGETTO.setText (Lingua.frase("IDENTIFICATORE"));  </code>
       *  Al termine si deve invocare la "FineImpostaFrasi" per apportare le modifiche.
       */  
  protected abstract void impostaFrasi ();

      /**
       *  Parte finale della "impostaFrasi" (dev'essere invocata al termine di essa)
       *  Esegue il ritracciamento grafico.
       */
  protected void FineImpostaFrasi () {
    revalidate();      // RIVALIDAZIONE DEL PANNELLO
  } //FineImpostaFrasi

      /**
       *  METODO RICHIESTO DALL'INTERFACCIA "LinguaListener".
       *  Viene invocato automaticamente quando qualcuno invoca la "Lingua.defLingua()"
       *  Ovviamente chiama "impostaFrasi()".
       */
  public void linguaCambiata () {
    impostaFrasi ();
  } //linguaCambiata

} //Pannello