/**  PanMappe
 *     Pannello per mostrare varie "mappe" sulla configurazione "avanzata" corrente.
 *     Si usa l'Anagrafe per reperire i dati sui place creati.
 *     Sebbene questo pannello sia usato solo da "AdvConfig" l'ho isolato in una
 *     singola classe per avere una maggior separazione dei compiti.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.*;
import SOMA.naming.PlaceID;

import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class PanMappe extends JTabbedPane implements LinguaListener, AnagrafeListener, 
                                                     ChangeListener {

      /**
       *  ICONE CARICATE UNA VOLTA SOLA ALLA CREAZIONE DELLA CLASSE!
       */
  protected static final ImageIcon IMG_ICO_PLADEF     = new ImageIcon(Finestra.PICTURE_PATH+"Persona.gif");
  protected static final ImageIcon IMG_ICO_PLANOR     = new ImageIcon(Finestra.PICTURE_PATH+"Personaggio.gif");
  protected static final ImageIcon IMG_ICO_PLACEVARI  = new ImageIcon(Finestra.PICTURE_PATH+"Persone.gif");
  protected static final ImageIcon IMG_ICO_PLADEFGRUP = new ImageIcon(Finestra.PICTURE_PATH+"PersoneUgu.gif");

  protected static final ImageIcon IMG_ICO_TAB_APPART = new ImageIcon(Finestra.PICTURE_PATH+"MiniPersone.gif");
  protected static final ImageIcon IMG_ICO_TAB_GERDNS = new ImageIcon(Finestra.PICTURE_PATH+"MiniPersoneUgu.gif");
  protected static final ImageIcon IMG_ICO_TAB_DOMII  = new ImageIcon(Finestra.PICTURE_PATH+"MiniPersona.gif");
  protected static final ImageIcon IMG_ICO_TAB_TUTTI  = new ImageIcon(Finestra.PICTURE_PATH+"MiniPersoneSub.gif");

  // Variabili PROTETTE:
      /**
       *  Per salvarsi i parametri passati al costruttore.
       */
  protected TreeSelectionListener ascoltatore;

      /**
       *  L'oggetto Anagrafe (passato al costruttore) a cui chiedere i dati sui Place.
       */
  protected Anagrafe anagrafe;

      /**
       *  Per salvarsi gli oggetti inseriti nei pannelli.
       */
  protected static final  int MAX_PAN = 4;
  protected JTree[]            albero    = new JTree [MAX_PAN];
  protected DefaultTreeModel[] modello   = new DefaultTreeModel[2];  // Solo per i primi 2 pannelli.


      /**
       *  Costruisce un "pannello di mappe".
       *  L'oggetto "TreeSelectionListener" passato verr avvisato ogniqualvolta
       *  l'utente seleziona sul pannello una rappresentazione di un place.
       *  Il pannello mette a disposizione alcuni differenti tipi di "visioni" del
       *  sistema; sono tutte strutture che vengono richiesti all'oggetto {@link SOMA.gui.Anagrafe}.
       *  Il TreeSelectionListener passato deve scrivere un suo metodo "valueChanged" con cui
       *  accedere al nodo dell'albero e prelevare il PlaceID contenuto nel nodo selezionato da utente.
       */
  public PanMappe (TreeSelectionListener ascoltatoreSelezione, Anagrafe anagrafe) {
    super ();

    this.ascoltatore = ascoltatoreSelezione;   // Mi devo ricordare chi ascolta
    this.anagrafe    = anagrafe;               // E l'oggetto Anagrafe a cui chiedere i dati

    Lingua.caricaFileDiLingua (PanMappe.class);

    aggiornaMappe ();

    impostaFrasi ();

    setSelectedIndex(0);  // parto col primo pannello (appartenenza)

    Lingua.addLinguaListener (this);        // SI REGISTRA SUL CAMBIO DI LINGUA
    anagrafe.addAnagrafeListener (this);    // E SUL CAMBIO DI ANAGRAFE

   // AGGIUNGE SE STESSO COME LISTENER - sono il listener di me stesso!
    addChangeListener (this);

  } //costruttore

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI).
       */
  protected void impostaFrasi () {
    setTitleAt (0, Lingua.frase("PM_MEMBERSHIP"));
    setTitleAt (1, Lingua.frase("PM_DNS_HIERAR"));
    setTitleAt (2, Lingua.frase("PM_DOMAINS"));
    setTitleAt (3, Lingua.frase("PM_EVERYBODY"));

    revalidate();      // RIVALIDAZIONE DEL PANNELLO
  } //impostaFrasi

      /**
       *  Metodo Interno.
       *  Dato un JTree ne definisce la rappresentazione (anche in base al
       *  numero del pannello in cui  inserito).
       *  Nota: verr imposta la per selezione singola, le icone dei vari nodi,
       *  e viene reso un JScrollPane che conterr tale albero.
       */
  protected JScrollPane creaMioAlbero (JTree albero, int numPannello) {
    albero.getSelectionModel().setSelectionMode (TreeSelectionModel.SINGLE_TREE_SELECTION);
    albero.setShowsRootHandles (true);

    // CAMBIO LE PROPRIETA' DI DEFAULT DEL JTree CREATO
    albero.putClientProperty("JTree.lineStyle", "Angled");
    albero.setScrollsOnExpand (true);
    albero.setRootVisible (false);   // NON faro' vedere la "root"

    // AGGIUNGO IL LISTENER per il JTree
    albero.addTreeSelectionListener (ascoltatore);

    // DEFINISCO IL "RENDERER" DEL JTree CREATO (disegno icone diverse)
    if ((numPannello == 0) || (numPannello == 3))        // per albero "appartenenza" e "tutti i place":

      albero.setCellRenderer(new RendererConOmarini());  // Vedi classe alla fine

    else {
      DefaultTreeCellRenderer myRenderer = new DefaultTreeCellRenderer();
      if (numPannello == 1) {
        myRenderer.setLeafIcon   (IMG_ICO_PLADEF);
        myRenderer.setOpenIcon   (IMG_ICO_PLADEF);
        myRenderer.setClosedIcon (IMG_ICO_PLADEFGRUP);
      }
      else { // numPannello=2
        myRenderer.setLeafIcon (IMG_ICO_PLADEF);
      }
      albero.setCellRenderer (myRenderer);
    }

    // Creo il JScrollPane in cui inserisco l'albero 
    JScrollPane alberoScorrevole = new JScrollPane (albero);
    Dimension dim = new Dimension(250,350);
    alberoScorrevole.setMinimumSize (dim);
    alberoScorrevole.setPreferredSize (dim);
    return alberoScorrevole;
  } //creaMioAlbero

      /**
       *  Permette la distruzione del pannello.
       *  Serve per rimuovere il pannello dai "listener" del cambio di lingua.
       */
  public void distruggimi () {
    Lingua.removeLinguaListener (this);
    anagrafe.removeAnagrafeListener (this);
  } //distruggimi

      /**
       *  Esegue l'aggiornamento di tutte le mappe (gli alberi) ricostruendoli
       *  daccapo, cio richiedendone la costruzione all'oggetto {@link SOMA.gui.Anagrafe}.
       *  E` invocato ogni volta che si verifica una "modifica d'anagrafe" (in 
       *  modo da riaggiornare gli alberi) dal metodo "anagrafeCambiata" di
       *  questo stesso pannello (che si  registrato per ascoltare le modifiche d'anagrafe).
       */
  public void aggiornaMappe () {
    String tipTap;  // Non esiste un modo per ridefinire i "tip" una volta creato il pannello!

    removeAll();  // Tolgo tutti i "pannelli"

    modello[0] = anagrafe.alberoPlaceNeiDominii ();
    albero[0] = new JTree (modello[0]);
    espandiTuttoLAbero (albero[0], (DefaultMutableTreeNode)modello[0].getRoot());
    tipTap = Lingua.frase("PM_TIP_PAN_0");
    addTab ("", IMG_ICO_TAB_APPART, creaMioAlbero(albero[0], 0), tipTap);

    modello[1] = anagrafe.alberoGerarchiaDNS();
    albero[1] = new JTree (modello[1]);
    espandiTuttoLAbero (albero[1], (DefaultMutableTreeNode)modello[1].getRoot());
    tipTap = Lingua.frase("PM_TIP_PAN_1");
    addTab ("", IMG_ICO_TAB_GERDNS, creaMioAlbero(albero[1], 1), tipTap);

    albero[2] = new JTree (anagrafe.listaPlaceDefault());
    tipTap = Lingua.frase("PM_TIP_PAN_2");
    addTab ("", IMG_ICO_TAB_DOMII, creaMioAlbero(albero[2], 2), tipTap);

    albero[3] = new JTree (anagrafe.listaOgniPlace());
    tipTap = Lingua.frase("PM_TIP_PAN_3");
    addTab ("", IMG_ICO_TAB_TUTTI, creaMioAlbero(albero[3], 3), tipTap);

    impostaFrasi ();   // per le frasi sul pannello

    revalidate();      // RIVALIDAZIONE DEL PANNELLO
  } //aggiornaMappe

      /**
       *  Metodo interno; espande l'intero albero in modo che tutti i nodi
       *  siano visibili.  E` richiesto sia l'albero (JTree) sia il nodo iniziale
       *  da cui espandere (DefaultMutableTreeNode), che in genere  la radice.
       */
  protected void espandiTuttoLAbero (JTree albero, DefaultMutableTreeNode nodoAtt) {
    Enumeration enum = nodoAtt.children();            // Scorro uno a uno tutti i figli del nodo.
    while (enum.hasMoreElements()) {
      DefaultMutableTreeNode figgiu = (DefaultMutableTreeNode) enum.nextElement();
      TreeNode[] arrPercFiglio = figgiu.getPath();    // percorso da radice a figlio
      TreePath percorsoFiglio = new TreePath(arrPercFiglio);
      albero.expandPath (percorsoFiglio);             // ESPANDO IL NODO "DOMINIO"
      espandiTuttoLAbero (albero, figgiu);    // ESPANDO RICORSIVAMENTE I NODI DEL FIGLIO
    }
  } //espandiTuttoLAbero

      /**
       *  METODO RICHIESTO DALL'INTERFACCIA "LinguaListener".
       *  Viene invocato automaticamente quando qualcuno invoca la "Lingua.defLingua()"
       *  Ovviamente chiama "impostaFrasi()".
       */
  public void linguaCambiata () {
    aggiornaMappe ();   // Ricreo tutto perch NON c' modo di modificare il "tool-tip" del tabbed-pane!
  } //linguaCambiata

      /**
       *  METODO RICHIESTO DALL'INTERFACCIA "AnagrafeListener".
       *  Viene invocato automaticamente quando qualcuno invoca la "anagrafe.battezzaPlace()"
       *  Ovviamente chiama "aggiornaMappe()".
       */
  public void anagrafeCambiata () {
    aggiornaMappe ();
  } //anagrafeCambiata

      /**
       *  METODO RICHIESTO DALL'INTERFACCIA "ChangeListener".
       *  Viene invocato automaticamente quando l'utente cambia il "tabbed-pane" mostrato.
       *  Serve per lanciare un "treeSelection" al listener di questo pannello.
       */
  public void stateChanged (ChangeEvent e) {
    int selez = getSelectedIndex();
    if (selez >= 0) {
      JTree cheAlb = albero[selez];
      TreePath mioPerc = cheAlb.getLeadSelectionPath();
      TreeSelectionEvent treeSelEvent = new TreeSelectionEvent (cheAlb, mioPerc, 
                                                              true, mioPerc, mioPerc);
      // Parametri: Object source, TreePath path, boolean isNew,
      //             TreePath oldLeadSelectionPath, TreePath newLeadSelectionPath)
      ascoltatore.valueChanged (treeSelEvent);   // CHIAMO DIRETTAMENTE L'UNICO ASCOLTATORE!
    }
  } //stateChanged


      /**
       *  CLASSE INTERNA PER IL RENDERING DELL'ALBERO: icona a seconda di place o dominio!
       *  Viene usato da "aggiornaMappe".
       */
  protected class RendererConOmarini extends DefaultTreeCellRenderer {

      /**
       *  Sovrascrivo la "getTreeCellRendererComponent" del rendering di default.
       */
    public Component getTreeCellRendererComponent (JTree tree,
                                                   Object value,
                                                   boolean sel,
                                                   boolean expanded,
                                                   boolean leaf,
                                                   int row,
                                                   boolean hasFocus) {
      super.getTreeCellRendererComponent (tree, value,
                                          sel, expanded, leaf, 
                                          row, hasFocus);
      DefaultMutableTreeNode nodo = (DefaultMutableTreeNode)value;
      Object info = nodo.getUserObject();
      if (info instanceof PlaceID)
        if ( ((PlaceID)info).isDomain() )
          if (expanded || leaf)
            setIcon(IMG_ICO_PLADEF); // dominio singolo
          else
            setIcon(IMG_ICO_PLACEVARI);  // place di default + sottoplace non espansi
        else
          setIcon(IMG_ICO_PLANOR);     // place normale (di un dominio)
      else
        setIcon(IMG_ICO_PLANOR);       // mah. non dovrebbe mai apparire (la root ha una stringa)
      return this;
    } //getTreeCellRendererComponent

  } //RendererConOmarini


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    JFrame F = new JFrame ();
    F.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    F.addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent e) { 
                          System.exit(0); 
                        } });
    Container contentPane = F.getContentPane();
    contentPane.add (new PanMappe(    new TreeSelectionListener () {
                        public void valueChanged (TreeSelectionEvent e) {
                          System.out.println ("SELEZIONATO: "+e.getSource().toString());
                          DefaultMutableTreeNode nodoSelez = (DefaultMutableTreeNode) 
                                                   ((JTree)e.getSource()).getLastSelectedPathComponent();
                          System.out.println ("             "+nodoSelez.toString());
                        }
                      },//ListSelTree
                      new Anagrafe()
                     ),
               BorderLayout.CENTER);
    F.pack();
    F.setVisible (true);          // INFINE RENDO VISIBILE LA FINESTRA
  }
*/

} //PanMappe