/**  PanFontDim
 *     Pannello per modificare la dimensione del font usato per visualizzare una text-area.
 *     @author     Luigi Antenucci
 *     @version    1.5
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.io.Serializable;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class PanFontDim extends Pannello {

  // Variabili PROTETTE:
      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel   fontLabel;
  protected JSlider  fontSlider;

      /**
       *  Parametro passato al costruttore; dimensione iniziale.
       */
  protected int dimAtt;


      /**
       *  Costruisco il pannello.
       */
  public PanFontDim (int dimAtt) {
    super ();

    this.dimAtt = dimAtt;

    costruisciPannello ();
  } //costruttore

      /**
       *  Costruzione del pannello
       */
  public void costruisciPannello () {

    fontLabel  = new JLabel ();
    fontSlider = new JSlider (JSlider.HORIZONTAL, 8, 16, dimAtt);
    fontSlider.setMajorTickSpacing (2);
    fontSlider.setMinorTickSpacing (1);
    fontSlider.setPaintTicks  (true);
    fontSlider.setPaintLabels (true);
    fontSlider.setSnapToTicks (true);

    GridBagLayout GBL3     = new GridBagLayout();
    GridBagConstraints CC3 = new GridBagConstraints();
    setLayout (GBL3);

    CC3.anchor = GridBagConstraints.CENTER;
    CC3.gridx = 1;   CC3.gridy = 1;
    GBL3.setConstraints (fontLabel, CC3);
    add (fontLabel);

    CC3.gridx = 1;   CC3.gridy = 2;
    GBL3.setConstraints (fontSlider, CC3);
    add (fontSlider);

    impostaFrasi ();

    FineCostruisciPannello();
  } //costruisciPannello

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI).
       */
  protected void impostaFrasi () {
    fontLabel .setText (Lingua.frase("PFONT_TXT_SLIDER"));

    fontSlider.setToolTipText (Lingua.frase("PFONT_TIP_SLIDER"));

    FineImpostaFrasi();
  } //impostaFrasi

      /**
       *  Ci si registra come LISTENER dell'oggetto. 
       *  Ogni listener deve implementare l'interfaccia "ChangeListener" (di javax.swing)
       *  e sara' avvisato quando avviene un cambio di font.
       */
  public void addChangeListener (ChangeListener cheListener) {
    fontSlider.addChangeListener (cheListener);
  } //addChangeListener

      /**
       *  Funzione inversa di "addChangeListener"; serve per annullare
       *  una precedente registrazione di un Listener.
       */
  public void removeChangeListener (ChangeListener cheListener) {
    fontSlider.removeChangeListener (cheListener);
  } //removeChangeListener

      /**
       *  Ottiene il valore dello slider.
       */
  public int cheDim () {
    return fontSlider.getValue();
  } //cheDim

      /**
       *  Imposta il valore dello slider.
       */
  public void defDim (final int nuovaDim) {
    SwingUtilities.invokeLater (new Runnable () {
        public void run () {
          fontSlider.setValue (nuovaDim);
        } //run
    }); //invokeLater
  } //cheDim

      /**
       *  Rende il riferimento all'oggetto JSlider.
       */
  public JSlider cheSlider () {
    return fontSlider;
  } //cheSlider


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    JFrame F = new JFrame ();
    F.addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent e) { 
                          System.exit(0); 
                        } });
    Container contentPane = F.getContentPane();
    PanFontDim panFontDim = new PanFontDim (12);
    panFontDim.addChangeListener (new ChangeListener () {
                                    public void stateChanged (ChangeEvent e) {
                                      int dim = ( (JSlider)e.getSource() ).getValue();
                                      System.out.println ("CAMBIATO A "+dim);
                                    }
                                  });
    contentPane.add (panFontDim);
    F.pack();
    F.setVisible (true);          // INFINE RENDO VISIBILE LA FINESTRA
  }
*/

} //PanFontDim