/**  ListClose
 *     Listener per la chiusura della finestra SENZA l'uscita dal sistema!
 *     Viene distrutta la finestra (a cui  associato) ma non si esce dal sistema.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2
 */
package SOMA.gui;

import java.io.Serializable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


public class ListClose extends WindowAdapter implements ActionListener, Serializable {

      /**
       *  Riferimenti ai dati passati al costruttore.
       */
  protected Finestra cheFin;

      /**
       *  Costruttore, con l'oggetto Finestra da distruggere.
       */
  public ListClose (Finestra cheFin) {
    this.cheFin = cheFin;
  } //costruttore

      /**
       *  Metodo richiesto dalla classe WindowAdapter.
       */
  public void windowClosing (WindowEvent e)   { 
    cheFin.distruggiFinestra ();
  } //windowClosing

      /**
       *  Metodo richiesto dall'interfaccia ActionListener.
       */
  public void actionPerformed (ActionEvent e) { 
    cheFin.distruggiFinestra ();
  } //actionPerformed

} //ListClose