/**  FinProfileDisting
 *     Una finestrella in cui mostrare le informazioni distintive di un profilo.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.security.infrastructure.ProfileManager;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class FinProfileDisting extends Finestra {

  // Variabili d'istanza:

      /**
       *  Riferimenti dati tramite il costruttore.
       */ 
  protected ProfileManager profile;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labDisting;
  protected JTextField txtDisting;
  protected JButton    botChiudi;


      /**
       *  Costruisce e mostra la finestra di informazioni.
       */ 
  public FinProfileDisting (ProfileManager profile) {
    super (250, 120);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.profile = profile;

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labDisting = new JLabel ();

    txtDisting = new JTextField (30);
    txtDisting.setEnabled (false);

    botChiudi  = new JButton ();

    String datoDato;
    try {
    	datoDato = profile.getDistinguishName();
    }
    catch (Exception e) {
      datoDato = Lingua.frase("FPRODIST_SECUERROR");
    }
    txtDisting.setText (datoDato);

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose listClose = new ListClose(this);

    botChiudi.setCursor (cursoreBottone);
    botChiudi.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botChiudi.addActionListener (listClose);

    mioFrame.addWindowListener (listClose);  // Per la chiusura della finestra

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    JPanel panX = new JPanel ();                       // PLACE ID
      GridBagLayout GBL3     = new GridBagLayout();
      GridBagConstraints CC3 = new GridBagConstraints();
      panX.setLayout (GBL3);

      CC3.anchor = GridBagConstraints.EAST;
      CC3.gridx = 1;   CC3.gridy = 1;
      GBL3.setConstraints (labDisting, CC3);
      panX.add (labDisting);

      CC3.anchor = GridBagConstraints.WEST;
      CC3.gridx = 2;   CC3.gridy = 1;
      GBL3.setConstraints (txtDisting, CC3);
      panX.add (txtDisting);

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (panX, CC);
    PanCentro.add (panX);
    
    spazio = Box.createRigidArea (new Dimension(5,20));
    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 9;
    GBL.setConstraints (botChiudi, CC);
    PanCentro.add (botChiudi);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FPRODIST_WINTITLE"));

    labDisting.setText (Lingua.frase("FPRODIST_DISTINGUISH"));
    botChiudi.setText  (Lingua.frase("FPRODIST_BOT_CHIUDI"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    ProfileManager profile = new ProfileManager();
    FinProfileDisting fin = new FinProfileDisting(profile);
  } //main
*/

} //FinProfileDisting