/**  FinProfileChPass
 *     Una finestrella tramite cui cambiare la password del profilo
 *     @author     Luigi Antenucci
 *     @version    1.2
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.security.infrastructure.ProfileManager;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;


public class FinProfileChPass extends Finestra {

      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final  String AZIONE_CAMBIA  = "Cambia";
  protected static final  String AZIONE_CANCEL  = "Annulla";


  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */ 
  protected FinestraPlace  finestraPlace;
  protected ProfileManager profile;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel         labSpiega,
                           labOld, labNew1, labNew2;
  protected JPasswordField txtOld, txtNew1, txtNew2;
  protected JButton        botCambia,
                           botKO;

      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */ 
  public FinProfileChPass (FinestraPlace finestraPlace, ProfileManager profile) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraPlace = finestraPlace;
    this.profile       = profile;
    if (finestraPlace != null)
      finestraPlace.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega     = new JLabel ();

    labOld        = new JLabel ();
    labNew1       = new JLabel ();
    labNew2       = new JLabel ();

    txtOld        = new JPasswordField (10);
    txtNew1       = new JPasswordField (10);
    txtNew2       = new JPasswordField (10);

    botCambia     = new JButton();
    botKO         = new JButton();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni();

    botCambia.setCursor (cursoreBottone);
    botKO    .setCursor (cursoreBottone);

    botCambia    .setCursor (cursoreBottone);
    botCambia    .setIcon (new ImageIcon(PICTURE_PATH+"ProfChPass.gif"));
    botCambia    .addActionListener (bottoniera);
    botCambia    .setActionCommand(AZIONE_CAMBIA);
    botKO        .setCursor (cursoreBottone);
    botKO        .setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO        .addActionListener (bottoniera);
    botKO        .setActionCommand(AZIONE_CANCEL);
    botKO        .setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    txtOld .setActionCommand(AZIONE_CAMBIA);
    txtOld .addActionListener (bottoniera);    // PRESSIONE "INVIO" SU TextField
    txtNew1.setActionCommand(AZIONE_CAMBIA);
    txtNew1.addActionListener (bottoniera);
    txtNew2.setActionCommand(AZIONE_CAMBIA);
    txtNew2.addActionListener (bottoniera);

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    JPanel panLog = new JPanel ();                       // PLACE ID
      GridBagLayout GBL2     = new GridBagLayout();
      GridBagConstraints CC2 = new GridBagConstraints();
      panLog.setLayout (GBL2);

      CC2.anchor = GridBagConstraints.EAST;
      CC2.gridx = 1;   CC2.gridy = 1;
      GBL2.setConstraints (labOld, CC2);
      panLog.add (labOld);
      CC2.gridx = 1;   CC2.gridy = 3;
      GBL2.setConstraints (labNew1, CC2);
      panLog.add (labNew1);
      CC2.gridx = 1;   CC2.gridy = 5;
      GBL2.setConstraints (labNew2, CC2);
      panLog.add (labNew2);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 2;   CC2.gridy = 1;
      GBL2.setConstraints (txtOld, CC2);
      panLog.add (txtOld);
      CC2.gridx = 2;   CC2.gridy = 3;
      GBL2.setConstraints (txtNew1, CC2);
      panLog.add (txtNew1);
      CC2.gridx = 2;   CC2.gridy = 5;
      GBL2.setConstraints (txtNew2, CC2);
      panLog.add (txtNew2);

      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 2;
      GBL2.setConstraints (spazio, CC2);
      panLog.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 4;
      GBL2.setConstraints (spazio, CC2);
      panLog.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,10));
      CC2.gridx = 2;   CC2.gridy = 6;
      GBL2.setConstraints (spazio, CC2);
      panLog.add (spazio);

    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 8;
    GBL.setConstraints (panLog, CC);
    PanCentro.add (panLog);

    CC.fill   = GridBagConstraints.VERTICAL;
    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 10;
    GBL.setConstraints (botCambia, CC);
    PanCentro.add (botCambia);

    CC.anchor = GridBagConstraints.EAST;
    CC.gridx = 1;   CC.gridy = 10;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {

    super.distruggiFinestra();

    if (finestraPlace != null) {
      finestraPlace.abilitaFinestra();
      finestraPlace.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FPROCHPA_WINTITLE"));

    labSpiega.setText (Lingua.frase("FPROCHPA_SPIEGAZ"));

    labOld  .setText (Lingua.frase("FPROCHPA_OLDPASS"));
    labNew1 .setText (Lingua.frase("FPROCHPA_NEWPASS1"));
    labNew2 .setText (Lingua.frase("FPROCHPA_NEWPASS2"));

    botCambia.setText (Lingua.frase("FPROCHPA_BOT_CAMBIA"));
    botKO    .setText (Lingua.frase("FPROCHPA_BOT_CANC"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      try {

        if (azione.equals(AZIONE_CAMBIA)) {
          // PRELEVA PARAMETRI
          String old  = new String(txtOld .getPassword());
          String new1 = new String(txtNew1.getPassword());
          String new2 = new String(txtNew2.getPassword());

          if (new1.equals(new2) && 
              (! new1.equals(old)) &&
              (! new1.equals(""))    ) {

                //...profile.cambia pass non esiste ancora
          }

          throw new Exception ("THIS FUNCTION IS NOT YET AVAILABLE");  //...

        }
        else // ANNULLA
          distruggiFinestra();    // Altrimenti, distruggo questa finestra!

      }
      catch (Exception eccezione) {
        OiDialogoi.mostraErrore (eccezione, mioFrame);    // STAMPA L'ECCEZIONE GENERATA!
      }
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    ProfileManager profile = new ProfileManager();
    FinProfileChPass fin = new FinProfileChPass(null, profile);
  } //main
*/

} //FinProfileChPass