/**  FinPlaceInfo
 *     Una finestrella in cui mostrare le informazioni su un Place.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.naming.PlaceID;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class FinPlaceInfo extends Finestra {

  // Variabili d'istanza:

      /**
       *  Il PlaceID di cui mostrare le informazioni.
       */ 
  protected PlaceID placeID;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labPlaceID,  labChiSono;
  protected JTextField txtPlaceID,  txtChiSono;
  protected JButton    botChiudi;


      /**
       *  Costruisce e mostra la finestra di informazioni.
       */ 
  public FinPlaceInfo (PlaceID placeID) {
    super (200, 100);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.placeID = placeID;

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labPlaceID = new JLabel ();
    labChiSono = new JLabel ();

    txtPlaceID = new JTextField (20);
    txtPlaceID.setEnabled (false);
    txtChiSono = new JTextField (20);
    txtChiSono.setEnabled (false);

    botChiudi  = new JButton ();

    txtPlaceID.setText (placeID.toString());
    txtChiSono.setText (placeID.getDomainID().toString());

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose listClose = new ListClose(this);

    botChiudi.setCursor (cursoreBottone);
    botChiudi.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botChiudi.addActionListener (listClose);

    mioFrame.addWindowListener (listClose);  // Per la chiusura della finestra

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    JPanel panX = new JPanel ();                       // PLACE ID
      GridBagLayout GBL3     = new GridBagLayout();
      GridBagConstraints CC3 = new GridBagConstraints();
      panX.setLayout (GBL3);

      CC3.anchor = GridBagConstraints.EAST;
      CC3.gridx = 1;   CC3.gridy = 1;
      GBL3.setConstraints (labPlaceID, CC3);
      panX.add (labPlaceID);

      CC3.anchor = GridBagConstraints.WEST;
      CC3.gridx = 2;   CC3.gridy = 1;
      GBL3.setConstraints (txtPlaceID, CC3);
      panX.add (txtPlaceID);

      spazio = Box.createRigidArea (new Dimension(5,10));   // Aggiunge spazio vuoto
      CC3.gridx = 2;   CC3.gridy = 2;
      GBL3.setConstraints (spazio, CC3);
      panX.add (spazio);

      CC3.anchor = GridBagConstraints.EAST;
      CC3.gridx = 1;   CC3.gridy = 3;
      GBL3.setConstraints (labChiSono, CC3);
      panX.add (labChiSono);

      CC3.anchor = GridBagConstraints.WEST;
      CC3.gridx = 2;   CC3.gridy = 3;
      GBL3.setConstraints (txtChiSono, CC3);
      panX.add (txtChiSono);

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (panX, CC);
    PanCentro.add (panX);

    spazio = Box.createRigidArea (new Dimension(5,20));
    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 9;
    GBL.setConstraints (botChiudi, CC);
    PanCentro.add (botChiudi);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FINF_WINTITLE"));

    labPlaceID.setText (Lingua.frase("FINF_PLACE_ID"));
    if (placeID.isDomain()) 
      labChiSono.setText (Lingua.frase("FINF_I_AM_DEFAULT"));
    else
      labChiSono.setText (Lingua.frase("FINF_I_AM_A_PLACE"));

    botChiudi.setText (Lingua.frase("FINF_BOT_CHIUDI"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    new FinPlaceInfo (new PlaceID("Italia", ""));
    new FinPlaceInfo (new PlaceID("Italia", "Bologna"));
  } //main
*/

} //FinPlaceInfo