/**  FinLocalHost
 *     Una finestrella in cui mostrare le informazioni sull'indirizzo del computer locale.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.net.InetAddress;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class FinLocalHost extends Finestra {

  // Variabili d'istanza:

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel     labIndir,  labNome;
  protected JTextField txtIndir,  txtNome;
  protected JButton    botChiudi;

      /**
       *  L'indirizzo IP passato al costruttore.
       */ 
  protected InetAddress indirizzoIP;

      /**
       *  Per ricordarmi se l'indirizzo  sconosciuto o no.
       */ 
  protected boolean erroreUnknown;

      /**
       *  Costruisce e mostra la finestra di informazioni.
       */ 
  public FinLocalHost (InetAddress indirizzoIP, boolean erroreUnknown) {
    super (220, 120);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.indirizzoIP   = indirizzoIP;
    this.erroreUnknown = erroreUnknown;

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labIndir   = new JLabel ();
    labNome    = new JLabel ();

    txtIndir = new JTextField (20);
    txtIndir.setEnabled (false);
    txtNome  = new JTextField (20);
    txtNome.setEnabled (false);

    botChiudi  = new JButton ();

    if (! erroreUnknown) {
      txtIndir.setText(indirizzoIP.getHostAddress());
      txtNome .setText(indirizzoIP.getHostName());
    }

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose listClose = new ListClose(this);

    botChiudi.setCursor (cursoreBottone);
    botChiudi.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botChiudi.addActionListener (listClose);

    mioFrame.addWindowListener (listClose);  // Per la chiusura della finestra

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (labIndir, CC);
    PanCentro.add (labIndir);

    CC.gridx = 2;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (txtIndir, CC);
    PanCentro.add (txtIndir);
    
    spazio = Box.createRigidArea (new Dimension(5,15));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 4;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 6;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (labNome, CC);
    PanCentro.add (labNome);

    CC.gridx = 2;   CC.gridy = 6;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (txtNome, CC);
    PanCentro.add (txtNome);

    spazio = Box.createRigidArea (new Dimension(5,20));
    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 2;   CC.gridy = 9;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (botChiudi, CC);
    PanCentro.add (botChiudi);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FHST_WINTITLE"));

    labIndir.setText(Lingua.frase("FHST_ADDRESS"));
    labNome.setText (Lingua.frase("FHST_NAME"));

    if (erroreUnknown) {
      String errore = Lingua.frase("FHST_UNKNOWN");
      txtIndir.setText(errore);
      txtNome .setText(errore);
    }

    botChiudi.setText (Lingua.frase("FHST_BOT_CHIUDI"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    try {
      new FinLocalHost (InetAddress.getLocalHost(), false);
    }
    catch (Exception e)  { }
  } //main
*/

} //FinLocalHost