/**  FinCAAddress
 *     La finestra di "CA_Address" (usa un "ProfileManager")
 *     @author     Luigi Antenucci  (modificato da Angelo, per il SetOffLine e l'abilitazione dei men)
 *     @version    2.5
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.explorer.DirExplorerItem;
import SOMA.security.infrastructure.InfrastructureAddress;
import SOMA.security.infrastructure.ProfileManager;
import SOMA.security.infrastructure.Infrastructure;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;


public class FinCAAddress extends Finestra {

      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final  String AZIONE_SET       = "Setttete";
  protected static final  String AZIONE_DEFAULT   = "Default";
  protected static final  String AZIONE_LOCAL     = "VidaLoca";
  protected static final  String AZIONE_CONNECT   = "Connect";
  protected static final  String AZIONE_ON        = "On";
  protected static final  String AZIONE_OFF       = "Off";           // Aggiunto da Angelo
  protected static final  String AZIONE_CANCEL    = "Annulla";

  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */
  protected FinestraPlace      finestraPlace;
  protected ProfileManager     profile;

  // protected boolean nologin = true;  // aggiunto da Angelo

      /**
       *  Riferimento in pi, usato internamente da questa finestra.
       */
  protected InfrastructureAddress address = null;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel       labSpiega,
                         labAtt, labDef,
                         labCaHH, labLdapHH,
                         labCaIP, labCaPo, labLdapIP, labLdapPo;
  protected JTextField   txt1CaIP, txt1CaPo, txt1LdapIP, txt1LdapPo,
                         txt2CaIP, txt2CaPo, txt2LdapIP, txt2LdapPo;
  protected JButton      botSet, botDef, botLocal,
                         botConnect, botOn, botOff,   // aggiunto il bottone botOff da Angelo
                         botKO;

      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */
  public FinCAAddress (FinestraPlace finestraPlace, ProfileManager profile) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraPlace = finestraPlace;
    this.profile       = profile;
    if (finestraPlace != null)
      finestraPlace.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega = new JLabel ();
    labAtt    = new JLabel ();
    labDef    = new JLabel ();
    labCaHH   = new JLabel ();
    labCaIP   = new JLabel ();
    labCaPo   = new JLabel ();
    labLdapHH = new JLabel ();
    labLdapIP = new JLabel ();
    labLdapPo = new JLabel ();

    txt1CaIP   = new JTextField (16);
    txt1CaPo   = new JTextField ( 8);
    txt1LdapIP = new JTextField (16);
    txt1LdapPo = new JTextField ( 8);

    txt2CaIP   = new JTextField (16);
    txt2CaPo   = new JTextField ( 8);
    txt2LdapIP = new JTextField (16);
    txt2LdapPo = new JTextField ( 8);

    txt2CaIP   .setEditable(false);
    txt2CaPo   .setEditable(false);
    txt2LdapIP .setEditable(false);
    txt2LdapPo .setEditable(false);

    botSet     = new JButton ();
    botDef     = new JButton ();
    botLocal   = new JButton ();
    botConnect = new JButton ();
    botOn      = new JButton ();     //Aggiunti da Angelo
    botOff     = new JButton ();
    botKO      = new JButton ();

    aggiornaSchermata();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni();

    botSet     .setCursor (cursoreBottone);
    botSet     .setIcon (new ImageIcon(PICTURE_PATH+"CAAdSet.gif"));
    botSet     .addActionListener (bottoniera);
    botSet     .setActionCommand(AZIONE_SET);
    botDef     .setCursor (cursoreBottone);
    botDef     .setIcon (new ImageIcon(PICTURE_PATH+"CAAdDef.gif"));
    botDef     .addActionListener (bottoniera);
    botDef     .setActionCommand(AZIONE_DEFAULT);
    botLocal   .setCursor (cursoreBottone);
    botLocal   .setIcon (new ImageIcon(PICTURE_PATH+"CAAdLoc.gif"));
    botLocal   .addActionListener (bottoniera);
    botLocal   .setActionCommand(AZIONE_LOCAL);
    botConnect .setCursor (cursoreBottone);
    botConnect .setIcon (new ImageIcon(PICTURE_PATH+"CAAdCon.gif"));
    botConnect .addActionListener (bottoniera);
    botConnect .setActionCommand(AZIONE_CONNECT);
    botOn      .setCursor (cursoreBottone);                              //Aggiunti da Angelo
    botOn      .setIcon (new ImageIcon(PICTURE_PATH+"CAAdOnOf.gif"));
    botOn      .addActionListener (bottoniera);
    botOn      .setActionCommand(AZIONE_ON);
    botOff     .setCursor (cursoreBottone);
    botOff     .setIcon (new ImageIcon(PICTURE_PATH+"CAAdOnOf.gif"));
    botOff     .addActionListener (bottoniera);
    botOff     .setActionCommand(AZIONE_OFF);
    botKO      .setCursor (cursoreBottone);
    botKO      .setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO      .addActionListener (bottoniera);
    botKO      .setActionCommand(AZIONE_CANCEL);
    botKO      .setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    txt1CaIP   .setActionCommand(AZIONE_SET);
    txt1CaIP   .addActionListener (bottoniera);    // PRESSIONE "INVIO" SU TextField
    txt1CaPo   .setActionCommand(AZIONE_SET);
    txt1CaPo   .addActionListener (bottoniera);
    txt1LdapIP .setActionCommand(AZIONE_SET);
    txt1LdapIP .addActionListener (bottoniera);
    txt1LdapPo .setActionCommand(AZIONE_SET);
    txt1LdapPo .addActionListener (bottoniera);

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    Border bordino = BorderFactory.createCompoundBorder(
                       BorderFactory.createBevelBorder(BevelBorder.RAISED,
                                                       Color.white,  Color.lightGray,
                                                       Color.gray,   Color.lightGray),
                       BorderFactory.createEmptyBorder(2, 2, 2, 2) );   // alto,sx,basso,dx

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    spazio = Box.createRigidArea (new Dimension(2,10));
    CC.gridx = 1;   CC.gridy = 3;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    JPanel panDat = new JPanel ();                       // PLACE ID
      GridBagLayout GBL2     = new GridBagLayout();
      GridBagConstraints CC2 = new GridBagConstraints();
      panDat.setLayout (GBL2);
      panDat.setBorder (bordino);

      CC2.anchor = GridBagConstraints.CENTER;
      CC2.gridx = 2;   CC2.gridy = 0;
      GBL2.setConstraints (labAtt, CC2);
      panDat.add (labAtt);
      CC2.gridx = 4;   CC2.gridy = 0;
      GBL2.setConstraints (labDef, CC2);
      panDat.add (labDef);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 0;   CC2.gridy = 2;
      GBL2.setConstraints (labCaHH, CC2);
      panDat.add (labCaHH);
      CC2.anchor = GridBagConstraints.EAST;
      CC2.gridx = 0;   CC2.gridy = 4;
      GBL2.setConstraints (labCaIP, CC2);
      panDat.add (labCaIP);
      CC2.gridx = 0;   CC2.gridy = 6;
      GBL2.setConstraints (labCaPo, CC2);
      panDat.add (labCaPo);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 0;   CC2.gridy = 8;
      CC2.gridwidth = 3;
      GBL2.setConstraints (labLdapHH, CC2);
      panDat.add (labLdapHH);
      CC2.gridwidth = 1;
      CC2.anchor = GridBagConstraints.EAST;
      CC2.gridx = 0;   CC2.gridy = 10;
      GBL2.setConstraints (labLdapIP, CC2);
      panDat.add (labLdapIP);
      CC2.gridx = 0;   CC2.gridy = 12;
      GBL2.setConstraints (labLdapPo, CC2);
      panDat.add (labLdapPo);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 2;   CC2.gridy = 4;
      GBL2.setConstraints (txt1CaIP, CC2);
      panDat.add (txt1CaIP);
      CC2.gridx = 2;   CC2.gridy = 6;
      GBL2.setConstraints (txt1CaPo, CC2);
      panDat.add (txt1CaPo);
      CC2.gridx = 2;   CC2.gridy = 10;
      GBL2.setConstraints (txt1LdapIP, CC2);
      panDat.add (txt1LdapIP);
      CC2.gridx = 2;   CC2.gridy = 12;
      GBL2.setConstraints (txt1LdapPo, CC2);
      panDat.add (txt1LdapPo);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 4;   CC2.gridy = 4;
      GBL2.setConstraints (txt2CaIP, CC2);
      panDat.add (txt2CaIP);
      CC2.gridx = 4;   CC2.gridy = 6;
      GBL2.setConstraints (txt2CaPo, CC2);
      panDat.add (txt2CaPo);
      CC2.gridx = 4;   CC2.gridy = 10;
      GBL2.setConstraints (txt2LdapIP, CC2);
      panDat.add (txt2LdapIP);
      CC2.gridx = 4;   CC2.gridy = 12;
      GBL2.setConstraints (txt2LdapPo, CC2);
      panDat.add (txt2LdapPo);

      spazio = Box.createRigidArea (new Dimension(6,2));
      CC2.gridx = 1;   CC2.gridy = 4;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);
      spazio = Box.createRigidArea (new Dimension(6,2));
      CC2.gridx = 3;   CC2.gridy = 4;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);

      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 3;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 5;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 7;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 9;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 11;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,10));
      CC2.gridx = 2;   CC2.gridy = 13;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);

      CC2.fill = GridBagConstraints.BOTH;
      CC2.gridx = 2;   CC2.gridy = 15;
      GBL2.setConstraints (botSet, CC2);
      panDat.add (botSet);
      CC2.gridx = 4;   CC2.gridy = 15;
      GBL2.setConstraints (botDef, CC2);
      panDat.add (botDef);

      CC2.fill   = GridBagConstraints.NONE;
      CC2.anchor = GridBagConstraints.CENTER;
      CC2.gridx = 2;   CC2.gridy = 17;
      CC2.gridwidth = 3;
      GBL2.setConstraints (botLocal, CC2);
      panDat.add (botLocal);
      CC2.gridwidth = 1;

    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 5;
    GBL.setConstraints (panDat, CC);
    PanCentro.add (panDat);

    spazio = Box.createRigidArea (new Dimension(2,10));
    CC.gridx = 1;   CC.gridy = 6;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.fill   = GridBagConstraints.VERTICAL;    // modificato il Layout da Angelo

    CC.gridx = 1;   CC.gridy = 10;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (botConnect, CC);
    PanCentro.add (botConnect);

    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (botOn, CC);
    PanCentro.add (botOn);

    CC.anchor = GridBagConstraints.EAST;    // Aggiunto da Angelo
    GBL.setConstraints (botOff, CC);
    PanCentro.add (botOff);

    CC.gridx = 1;   CC.gridy = 16;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {

    super.distruggiFinestra();

    if (finestraPlace != null) {
      finestraPlace.abilitaFinestra();
      finestraPlace.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FCAAD_WINTITLE"));

    labSpiega.setText (Lingua.frase("FCAAD_SPIEGAZ"));

    labAtt   .setText (Lingua.frase("FCAAD_CURRENT"));
    labDef   .setText (Lingua.frase("FCAAD_DEFAULT"));
    labCaHH  .setText (Lingua.frase("FCAAD_CA_HEADER"));
    labCaIP  .setText (Lingua.frase("FCAAD_CAIP"));
    labCaPo  .setText (Lingua.frase("FCAAD_CAPO"));
    labLdapHH.setText (Lingua.frase("FCAAD_LDAP_HEADER"));
    labLdapIP.setText (Lingua.frase("FCAAD_LDAPIP"));
    labLdapPo.setText (Lingua.frase("FCAAD_LDAPPO"));

    botSet    .setText (Lingua.frase("FCAAD_BOT_SET"));
    botDef    .setText (Lingua.frase("FCAAD_BOT_DEFAULT"));
    botLocal  .setText (Lingua.frase("FCAAD_BOT_LOCAL"));
    botConnect.setText (Lingua.frase("FCAAD_BOT_CONNECT"));

    botOn  .setText  (Lingua.frase("FCAAD_BOT_ON"));
    botOff.setText(Lingua.frase("FCAAD_BOT_OFF"));   // aggiunto da Angelo

    botKO     .setText (Lingua.frase("FCAAD_BOT_CANC"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      /**
       *  Riempie i dati della finestra
       */
  protected void aggiornaSchermata () {
    SwingUtilities.invokeLater (new Runnable () {
        public void run () {
          if (address != null) {
            txt1CaIP  .setText (address.getManagerIP());
            txt1CaPo  .setText (String.valueOf(address.getManagerPort()));
            txt1LdapIP.setText (address.getDirectoryIP());
            txt1LdapPo.setText (String.valueOf(address.getDirectoryPort()));
          }
          else {
            txt1CaIP  .setText ("");
            txt1CaPo  .setText ("");
            txt1LdapIP.setText ("");
            txt1LdapPo.setText ("");
          }

          txt2CaIP  .setText (InfrastructureAddress.CA_IP);
          txt2CaPo  .setText (String.valueOf(InfrastructureAddress.DEFAULT_CA_PORT));
          txt2LdapIP.setText (InfrastructureAddress.DIR_IP);
          txt2LdapPo.setText (String.valueOf(InfrastructureAddress.DEFAULT_LDAP_PORT));

          boolean abilita = (address != null);
          botConnect.setEnabled(abilita);
          botOn     .setEnabled(abilita);

          botOff    .setEnabled(abilita);
        } //run
    }); //invokeLater
  } //aggiornaSchermata


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();

      try {

        if (azione.equals(AZIONE_SET)) {
          if (address == null) {
            address = new InfrastructureAddress();
          }
          address.setManagerIP    (txt1CaIP.getText());
          address.setManagerPort  (Integer.parseInt(txt1CaPo.getText()));
          address.setDirectoryIP  (txt1LdapIP.getText());
          address.setDirectoryPort(Integer.parseInt(txt1LdapPo.getText()));
          aggiornaSchermata();
        }
        else if (azione.equals(AZIONE_DEFAULT)) {
          if (address == null) {
            address = new InfrastructureAddress();
          }
          address.setManagerIP    (InfrastructureAddress.CA_IP);
          address.setManagerPort  (InfrastructureAddress.DEFAULT_CA_PORT);
          address.setDirectoryIP  (InfrastructureAddress.DIR_IP);
          address.setDirectoryPort(InfrastructureAddress.DEFAULT_LDAP_PORT);
          aggiornaSchermata();
        }
        else if (azione.equals(AZIONE_LOCAL)) {
          address = new InfrastructureAddress();
          aggiornaSchermata();
        }
        else if (azione.equals(AZIONE_CONNECT)) {
          if (address != null) {
            Thread esecutore = new Thread ("NonConnettoPiu") {
                public void run() {
                  try {
                    //DEBUG: if (finestraPlace != null)
                    //DEBUG:   finestraPlace.abilitaVociSicurezza(FinestraPlace.VOCE_LOGIN);

                    address.checkCiphers();
                    address.connectDirectory();
                    Infrastructure pki = new Infrastructure (address);
                    profile.setEntrustInfrastructure (pki);

                    // Abilita nella FinestraPlace la voce "login" se necessario by Angelo
                    if ( (finestraPlace != null) && finestraPlace.nologin )
                      finestraPlace.abilitaVociSicurezza(FinestraPlace.VOCE_LOGIN);

                    distruggiFinestra();
                  }
                  catch (Exception eccez) {
                    OiDialogoi.mostraErrore (eccez, mioFrame);
                  }
                } //run
            }; //esecutore (Thread)
            esecutore.start();
            OiDialogoi.mostraMessaggio (Lingua.frase("FCAAD_MES_CONNECT"), mioFrame);
          }
        }
        else if (azione.equals(AZIONE_ON)) {         // aggiunto da Angelo
          if (address != null) {
            Thread esecutore = new Thread ("NonConnettoPiu") {
                public void run() {
                  try {
                    disabilitaFinestra();
                    // final boolean onLine = ! address.getOnLine();
                    address.setOnLine(true);
                    //botOff    .setEnabled(true);  // aggiunto da Angelo
                    //botOn    .setEnabled(false);
                    //SwingUtilities.invokeLater (new Runnable () {
                    //    public void run () {
                          //if (onLine)
                          //  botOnOff.setText(Lingua.frase("FCAAD_BOT_OFF"));   // setta bottone a "off-line
                          //else
                          //  botOnOff.setText(Lingua.frase("FCAAD_BOT_ON"));
                    //    } //run
                    //}); //invokeLater
                    aggiornaSchermata();
                  }
                  catch (Exception eccez) {
                    OiDialogoi.mostraErrore (eccez, mioFrame);
                  }
                  inPrimoPiano();
                  abilitaFinestra();
                } //run
            }; //esecutore (Thread)
            esecutore.start();
            OiDialogoi.mostraMessaggio (Lingua.frase("FCAAD_MES_STATUS"), mioFrame);
          }
        }
        else if (azione.equals(AZIONE_OFF)) {
          if (address != null) {
            Thread esecutore = new Thread ("NonConnettoPiu") {
                public void run() {
                  try {
                    // disabilitaFinestra();
                    //final boolean onLine = ! address.getOnLine();
                    address.setOnLine(false);

                    Infrastructure pki = new Infrastructure (address);
                    profile.setEntrustInfrastructure (pki);

                    if ( (finestraPlace != null) && finestraPlace.nologin ) {
                      finestraPlace.abilitaVociSicurezza(FinestraPlace.VOCE_LOGIN);
                      finestraPlace.nologin = false;
                      }
                    distruggiFinestra();

                    //SwingUtilities.invokeLater (new Runnable () {
                    //    public void run () {
                          //if (onLine)
                          //  botOnOff.setText(Lingua.frase("FCAAD_BOT_OFF"));   // setta bottone a "off-line
                          //else
                          //  botOnOff.setText(Lingua.frase("FCAAD_BOT_ON"));
                    //    } //run
                    //}); //invokeLater
                    //aggiornaSchermata();
                  }
                  catch (Exception eccez) {
                    OiDialogoi.mostraErrore (eccez, mioFrame);
                  }
                  //inPrimoPiano();
                  //abilitaFinestra();
                } //run
            }; //esecutore (Thread)
            esecutore.start();
            OiDialogoi.mostraMessaggio (Lingua.frase("FCAAD_MES_STATUS"), mioFrame);
          }
        }
        else //AZIONE_CANCEL
          // Altrimenti, distruggo questa finestra!
          distruggiFinestra();
      }
      catch (Exception eccez) {
        OiDialogoi.mostraErrore (eccez, mioFrame);
      }
    } //actionPerformed

    public void windowClosing (WindowEvent e)   {
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    ProfileManager myProfile = new ProfileManager();
    FinCAAddress fin = new FinCAAddress (null, myProfile);
  } //main
*/

} //FinCAAddress