/**  FinAgentMessage
 *     Una finestrella per la spedizione di messaggi verso gli agenti.
 *     @author     Luigi Antenucci
 *     @version    2.2
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.agent.Message;
import SOMA.naming.AgentID;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class FinAgentMessage extends Finestra {

      /**
       *  Costanti per la "modalit" di creazione della finestra.
       */
  public static final int MOSTRA_SOLO  = 0;    // solo bottoni "reply" e "chiudi"
  public static final int SCRIVI_NUOVO = 1;    // solo bottoni "invia" e "chiudi"
  public static final int IN_RISPOSTA  = 2;    // solo bottoni "invia" e "chiudi"


  // Variabili d'istanza:
      /**
       *  Il messaggio da mostrare/scrivere.
       */ 
  protected Message message;
  protected FinAgentMessageListener agente;
  protected int     modalita;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labMess,  
                       labMitt, labDest,
                       labText;
  protected JTextField txtMitt, txtDest;
  protected JTextArea  txtText;
  protected JButton    botSend, botReply, botClose;


      /**
       *  Costruzione della finestra per la visualizzazione o la scrittura di un nuovo messaggio 
       *  (da inviare) vuoto o con testo preso da un precedente messaggio (arrivato).
       *  NB: nel caso sia necessun l'azione di "invio", verr creato un bottone "INVIA" mentre
       *  nel caso si stia leggendo un messaggio arrivato, verr creato quello di "RISPONDI".
       *  Per questo serve sempre passare l'agente: si pu rispondere a un messaggio con un nuovo messaggio!
       *  L'agente  passato non come un normale {@link SOMA.agent.Agent} ma come un
       *  {@link SOMA.gui.FinAgentMessageListener} perch si specifica non un agente in quanto tale,
       *  ma un qualcuno (agente o meno) a cui dare il messaggio che dovr essere spedito.
       *  Se modalit = MOSTRA_SOLO, ci saranno solo i bottoni "reply" e "chiudi",
       *  Se modalit = SCRIVI_NUOVO, ci saranno solo i bottoni "invia" e "chiudi",
       *  Se modalit = IN_RISPOSTA, ci saranno solo i bottoni "invia" e "chiudi",
       */
  public FinAgentMessage (Message message, FinAgentMessageListener agente, int modalita) {
    super (30, 80);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    if (modalita == IN_RISPOSTA)
      this.message = new Message (message.message, message.to, message.from);  // Inverto mitt. e dest.
    else
      this.message  = message;
    this.agente   = agente;
    this.modalita = modalita;

    costruisciFinestra();
  } //costruttore

      /**
       *  Costruttore per leggere un messaggio arrivato (e eventualmente rispondere)
       */
  public FinAgentMessage (Message message, FinAgentMessageListener agente) {
    this (message, agente, MOSTRA_SOLO);
  } //costruttore

      /**
       *  Costruttore per scrivere un messaggio da zero (c' solo l'ID del mittente, che viene passato}
       */
  public FinAgentMessage (AgentID agentID, FinAgentMessageListener agente) {
    this (new Message ("", agentID, null),    // Inverto mitt. e dest.
          agente, SCRIVI_NUOVO);
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labMess = new JLabel ();
    labMitt = new JLabel ();
    labDest = new JLabel ();
    labText = new JLabel ();

    txtMitt = new JTextField (30);
    txtDest = new JTextField (30);
    txtText = new JTextArea  (6, 50);

    JScrollPane scrollTxtText = new JScrollPane (txtText);
    //scrollTxtText.setPreferredSize (new Dimension(250,100));
    //scrollTxtText.setMinimumSize (new Dimension(50,30));

    txtMitt.setText (message.from.toString());
    if ((modalita == MOSTRA_SOLO) || (modalita == IN_RISPOSTA)) {
      txtDest.setText (message.to.toString());
      txtText.setText (message.message.toString());
    }

    txtMitt.setEnabled (false);   // Il mittente NON  MAI modificabile!
    if (modalita == MOSTRA_SOLO) {
      txtDest.setEnabled (false);
      txtText.setEnabled (false);
    }
    else
      if (modalita == IN_RISPOSTA)
        txtDest.setEnabled (false);    // disabilito se sto rispondendo

    if (modalita == MOSTRA_SOLO) {
      botReply = new JButton ();
      botReply.setCursor (cursoreBottone);
    }
    else {
      botSend = new JButton ();
      botSend.setCursor (cursoreBottone);
    }
    botClose = new JButton ();
    botClose.setCursor (cursoreBottone);

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni(this, agente);

    if (modalita == MOSTRA_SOLO) {
      botReply.addActionListener (bottoniera);
      botReply.setActionCommand("reply");
      botReply.setIcon (new ImageIcon(PICTURE_PATH+"AgentMailReply.gif"));
    }
    else {
      botSend.addActionListener (bottoniera);
      botSend.setActionCommand("send");
      botSend.setIcon (new ImageIcon(PICTURE_PATH+"AgentMailSend.gif"));
    }

    botClose.addActionListener (bottoniera);
    botClose.setActionCommand("close");
    botClose.setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botClose.setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));
    
    // USO Window Listener
    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.WEST;
    CC.gridwidth = 2;
    GBL.setConstraints (labMess, CC);
    PanCentro.add (labMess);
    CC.gridwidth = 1;

    spazio = Box.createRigidArea (new Dimension(4,15));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (labMitt, CC);
    PanCentro.add (labMitt);
    CC.gridx = 2;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (txtMitt, CC);
    PanCentro.add (txtMitt);

    spazio = Box.createRigidArea (new Dimension(4,6));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 4;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 5;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (labDest, CC);
    PanCentro.add (labDest);
    CC.gridx = 2;   CC.gridy = 5;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (txtDest, CC);
    PanCentro.add (txtDest);

    spazio = Box.createRigidArea (new Dimension(4,6));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 6;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 7;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labText, CC);
    PanCentro.add (labText);

    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.WEST;
    CC.gridwidth = 2;
    GBL.setConstraints (scrollTxtText, CC);
    PanCentro.add (scrollTxtText);
    CC.gridwidth = 1;

    spazio = Box.createRigidArea (new Dimension(5,20));
    CC.gridx = 1;   CC.gridy = 9;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.fill = GridBagConstraints.VERTICAL;
    JButton cheBotSx;
    if (modalita == MOSTRA_SOLO) 
      cheBotSx = botReply;
    else
      cheBotSx = botSend;

    CC.gridx = 1;   CC.gridy = 10;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (cheBotSx, CC);
    PanCentro.add (cheBotSx);
    CC.gridx = 2;   CC.gridy = 10;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (botClose, CC);
    PanCentro.add (botClose);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FAGMES_WINTITLE"));

    if (modalita == MOSTRA_SOLO)
      labMess.setText (Lingua.frase("FAGMES_ARRIVED"));
    else
      labMess.setText (Lingua.frase("FAGMES_WRITEME"));

    labMitt.setText (Lingua.frase("FAGMES_SOURCE"));
    labDest.setText (Lingua.frase("FAGMES_DEST"));
    labText.setText (Lingua.frase("FAGMES_MESSAGE"));

    botClose.setText (Lingua.frase("FAGMES_BOT_CLOSE"));
    if (modalita == MOSTRA_SOLO)
      botReply.setText (Lingua.frase("FAGMES_BOT_REPLY"));
    else
      botSend .setText (Lingua.frase("FAGMES_BOT_SEND"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {
    protected FinAgentMessage miaFinAgentMessage;
    protected FinAgentMessageListener mioAgente;

    public ListBottoni (FinAgentMessage miaFinAgentMessage, FinAgentMessageListener mioAgente) {
      this.miaFinAgentMessage = miaFinAgentMessage;
      this.mioAgente = mioAgente;
    } //costruttore

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("send")) {
        if (mioAgente != null) {  //per sicurezza
          try {

            String testo = txtText.getText();
            AgentID agMitt, agDest;
            try {
              agMitt = new AgentID (txtMitt.getText());
            }
            catch (Exception ecciu) { 
              throw new Exception (Lingua.frase("FAGMES_ERR_SENDER"));
            }
            try {
              agDest = new AgentID (txtDest.getText());
            }
            catch (Exception ecciu) { 
              throw new Exception (Lingua.frase("FAGMES_ERR_RECEIV"));
            }

            Message message = new Message (testo, agMitt, agDest);  // Messaggio, Dachi, AChi

            try {

              agente.eseguiAzioneSend (message);    // LO DO ALL'AGENTE

              OiDialogoi.mostraMessaggio (Lingua.frase("FAGMES_MESS_SENT"), mioFrame);

              miaFinAgentMessage.distruggiFinestra();   // Se tutto bene, distruggo questa finestra
            }
            catch (Exception ecciu) {
              throw new Exception (Lingua.frase("FAGMES_ERR_CANT_SEND"));
            }

          }
          catch (Exception ecciu) {
            OiDialogoi.mostraErrore (ecciu, mioFrame);
          }
        }
      }
      else
        if (azione.equals("reply")) {
          // CREA UNA NUOVA FINESTRA DELLO STESSO TIPO (dandole il messaggio originale - a cui rispondere)
          FinAgentMessage fin = new FinAgentMessage (message, agente, IN_RISPOSTA);

          miaFinAgentMessage.distruggiFinestra();   // In ogni caso distruggo questa finestra

        }
        else // caso: "Annulla"
          miaFinAgentMessage.distruggiFinestra();   // In ogni caso distruggo questa finestra
    } //actionPerformed

    public void windowClosing (WindowEvent e)   {
      miaFinAgentMessage.distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni


/*
  public static void main (String[] args) throws Exception {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    new FinAgentMessage (new Message("Ciao Ciao", 
                                     new AgentID("Italia  6"),
                                     new AgentID("America Broadway 4313")), null, MOSTRA_SOLO);
  } //main
*/

} //FinAgentMessage