/**  FinAbout
 *     Finestrella per mostrare le "informazioni su.."
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class FinAbout extends Finestra implements MouseListener {

  // Variabili d'istanza:
      /**
       *  La finestra genitore, quella passata al costruttore
       */
  protected JFrame finGenit;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     lab1, lab1B, lab2,
                       labIco1, labIco2, labIco3;
  protected JButton    botOk;

  protected PanTestoSC testata;


      /**
       *  Costruisce e mostra la finestra di informazioni.
       */ 
  public FinAbout () {
    this (null);
  } //costruttore

      /**
       *  Costruisce e mostra la finestra di informazioni, "modale" alla finestra passata.
       */ 
  public FinAbout (JFrame finGenit) {
    super (150, 30);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE
    this.finGenit = finGenit;
    if (finGenit != null)
      finGenit.setEnabled(false);

    costruisciFinestra();
  } //costruttore

  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    testata = new PanTestoSC ();

    lab1    = new JLabel ();
    lab1B   = new JLabel ();
    lab2    = new JLabel ();

    labIco1  = new JLabel ();
    labIco2  = new JLabel ();
    labIco3  = new JLabel ();
    labIco1.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"Soma.gif"));
    labIco2.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"Unibo.gif"));
    labIco3.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"StemmaUnibo.gif"));

    labIco1.addMouseListener(this);

    botOk  = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose listClose = new ListClose(this);

    botOk.setCursor (cursoreBottone);
    botOk.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botOk.setVerticalTextPosition   (JButton.BOTTOM);
    botOk.setHorizontalTextPosition (JButton.CENTER);
    botOk.addActionListener (listClose);

    mioFrame.addWindowListener (listClose);  // Per la chiusura della finestra

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(8, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 2;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (testata, CC);
    PanCentro.add (testata);

    spazio = Box.createRigidArea (new Dimension(2,6));   // Aggiunge spazio vuoto
    CC.gridx = 2;   CC.gridy = 2;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 4;
    CC.anchor = GridBagConstraints.WEST;
    CC.gridheight = 2;
    GBL.setConstraints (labIco1, CC);
    PanCentro.add (labIco1);
    CC.gridheight = 1;

    spazio = Box.createRigidArea (new Dimension(10,2));   // Aggiunge spazio vuoto
    CC.gridx = 2;   CC.gridy = 4;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.anchor = GridBagConstraints.CENTER;
    CC.gridx = 2;   CC.gridy = 4;
    GBL.setConstraints (lab2, CC);
    PanCentro.add (lab2);

    CC.gridx = 2;   CC.gridy = 5;
    GBL.setConstraints (lab1, CC);
    PanCentro.add (lab1);

    CC.gridx = 2;   CC.gridy = 6;
    GBL.setConstraints (lab1B, CC);
    PanCentro.add (lab1B);

    spazio = Box.createRigidArea (new Dimension(2,10));   // Aggiunge spazio vuoto
    CC.gridx = 2;   CC.gridy = 7;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 8;
    CC.gridwidth = 2;
    GBL.setConstraints (labIco2, CC);
    PanCentro.add (labIco2);

    spazio = Box.createRigidArea (new Dimension(5,10));
    CC.gridx = 1;   CC.gridy = 12;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    JPanel panSotto = new JPanel();
    panSotto.add(labIco3);
    panSotto.add(botOk);

    CC.gridx = 1;   CC.gridy = 15;
    GBL.setConstraints (panSotto, CC);
    PanCentro.add (panSotto);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    super.distruggiFinestra();

    if (finGenit != null) {
      finGenit.setEnabled(true);
      finGenit.toFront();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("ABOUT_WIN_TITLE"));

    testata.setText (Lingua.frase("ABOUT_TESTATA"));

    lab2 .setText (Lingua.frase("ABOUT_LAB2"));
    lab1 .setText (Lingua.frase("ABOUT_LAB1"));
    lab1B.setText (Lingua.frase("ABOUT_LAB1B"));

    botOk.setText (Lingua.frase("ABOUT_BOT_OK"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

  public void mouseClicked (MouseEvent e) { }
  public void mousePressed (MouseEvent e) { }
  public void mouseReleased(MouseEvent e) { }
  public void mouseEntered (MouseEvent e) { 
    labIco1.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"SomaOn.gif"));
  }
  public void mouseExited  (MouseEvent e) {
    labIco1.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"Soma.gif"));
  }

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    FinAbout fin = new FinAbout ();
  } //main
*/

} //FinAbout