/**  DefPlace
 *     Finestra per definire e invocare la creazione di un PLACE "NORMALE"
 *     Per la creazione si invoca la {@link SOMA.gui.Creatore#crea()}, mentre per memorizzare la
 *     configurazione del place creato si usa la {@link SOMA.gui.Creatore#salvaConfigPlace()}; infine
 *     si visualizza la finestra del place tramite la {@link SOMA.gui.ActionPlace.start()}.
 *     NB: per la creazione viene usato un THREAD SEPARATO in modo che si esegua il codice (che 
 *     pu impiegare un certo tempo - non trascurabile - per eseguire) evitando in ogni caso di 
 *     bloccare la gestione degli eventi e il ritracciamento della GUI.
 *     Nota Bene: nel LAB2 della nostra facolt la prima (e solo la prima) creazione di un place 
 *     tiene il processo "bloccato" (misteriosamente) per ben 60-70 secondi! La cosa curiosa  che 
 *     tutte le successive creazioni sono velocissime (uno o due secondi).
 *     @author     Luigi Antenucci
 *     @version    3.3
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.Environment;
import SOMA.naming.PlaceID;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class DefPlace extends Finestra {

      /**
       *  Per memorizzare i parametri passati al costruttore, 
       *  in modo che siano visibili anche agli altri metodi.
       */
  protected Finestra finGenitore;
  protected boolean  advanced;
  protected PlaceID  dominioIniziale;
  protected Anagrafe anagrafe;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labSpiega,
                       labInsReg1, labInsReg2;
  protected JButton    botCrea, botCanc;
  protected JCheckBox  chkApriFin;
  protected JCheckBox  chkSicuro;

      /**
       *  Pannelli per input "particolari".
       */ 
  protected PanLocRem     panLocRem;
  protected PanNomePorta  panNomPor;

  protected PanTestoSC testata;


      /**
       *  Costruzione della finestra per l'input dei dati di creazione del place.
       */
  public DefPlace (Finestra finGenitore, boolean advanced,
                   Anagrafe anagrafe) {
    this (finGenitore, advanced, null, anagrafe);
  } //costruttore

      /**
       *  Costruzione della finestra per l'input dei dati di creazione del place.
       *  Porre "advanced" = true, se la si chiama dalla "advanced configuration".
       */
  public DefPlace (Finestra finGenitore, boolean advanced, 
                   PlaceID dominioIniziale, Anagrafe anagrafe) {
    super (60, 0);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finGenitore = finGenitore;
    this.advanced    = advanced;
    this.dominioIniziale = dominioIniziale;
    this.anagrafe    = anagrafe;

    finGenitore.disabilitaFinestra();

    costruisciFinestra();

  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    testata     = new PanTestoSC ();

    panLocRem   = new PanLocRem (PanLocRem.PAN_LOC_REM_DOM, anagrafe, dominioIniziale);
    panNomPor   = new PanNomePorta (PanNomePorta.PAN_PLACE);

    panLocRem.setBorder (BorderFactory.createEmptyBorder(0, 20, 10, 0));   // alto,sx,basso,dx

    labSpiega   = new JLabel ();
    labInsReg1  = new JLabel ();
    labInsReg2  = new JLabel ();

    botCrea     = new JButton ();
    botCanc     = new JButton ();

    botCrea.setCursor (cursoreBottone);
    botCanc.setCursor (cursoreBottone);

    chkApriFin  = new JCheckBox ();
    chkApriFin.setSelected (true);   // per dafault apre la finestra

    if (! advanced)
      chkApriFin.setEnabled (false);   // disabilito se non sono in config.avanzata

    chkSicuro   = new JCheckBox ();
    chkSicuro .setSelected (false);  // per dafault non  sicuro

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni(this);
    botCrea.addActionListener (bottoniera);
    botCanc.addActionListener (bottoniera);
    botCanc.setActionCommand("Annulla");

    botCrea.setIcon (new ImageIcon(PICTURE_PATH+"Inserisci.gif"));
    botCanc.setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botCanc.setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    panLocRem.addActionListener (bottoniera);
    panNomPor.addActionListener (bottoniera);

    // USO Window Listener
    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL     = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(8, 25, 4, 25));   // alto,sx,basso,dx

    CC.gridx = 1;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (testata, CC);
    PanCentro.add (testata);

    Component spazio = Box.createRigidArea (new Dimension(4,4));   // Aggiunge spazio vuoto
    CC.gridx = 4;   CC.gridy = 2;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 5;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labInsReg1, CC);
    PanCentro.add (labInsReg1);

    CC.gridx = 1;   CC.gridy = 6;
    GBL.setConstraints (labInsReg2, CC);
    PanCentro.add (labInsReg2);

    CC.gridx = 1;   CC.gridy = 9;
    GBL.setConstraints (panLocRem, CC);
    PanCentro.add (panLocRem);

    CC.gridx = 1;   CC.gridy = 13;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    spazio = Box.createRigidArea(new Dimension(4,4));
    CC.gridx = 1;   CC.gridy = 12;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);
    
    CC.gridx = 1;   CC.gridy = 15;
    GBL.setConstraints (panNomPor, CC);
    PanCentro.add (panNomPor);

    CC.gridx = 1;   CC.gridy = 20;
    GBL.setConstraints (chkSicuro, CC);
    PanCentro.add (chkSicuro);

    CC.gridx = 1;   CC.gridy = 25;
    GBL.setConstraints (chkApriFin, CC);
    PanCentro.add (chkApriFin);

    spazio = Box.createRigidArea(new Dimension(4,6));
    CC.gridx = 1;   CC.gridy = 30;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.fill = GridBagConstraints.VERTICAL;

    CC.gridx = 1;   CC.gridy = 33;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (botCrea, CC);
    PanCentro.add (botCrea);

    CC.gridx = 1;   CC.gridy = 33;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (botCanc, CC);
    PanCentro.add (botCanc);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    panLocRem.distruggimi();
    panNomPor.distruggimi();
    
    super.distruggiFinestra();

    finGenitore.abilitaFinestra ();
    finGenitore.inPrimoPiano();
  } //distruggiFinestra

      /**
       *  Disabilita la finestra. Vedi in superclasse {@link SOMA.gui.Finestra}.
       */
  public void disabilitaFinestra () {
    super.disabilitaFinestra();
    botCrea.setEnabled (false);
    botCanc.setEnabled (false);
    panLocRem.disabilitami ();
    panNomPor.disabilitami ();
    chkApriFin.setEnabled (false);
    chkSicuro .setEnabled (false);
  } //disabilitaFinestra

      /**
       *  Abilita la finestra (precedentemente disabilitata). Vedi in superclasse {@link SOMA.gui.Finestra}.
       */
  public void abilitaFinestra () {
    super.abilitaFinestra();
    botCrea.setEnabled (true);
    botCanc.setEnabled (true);
    panLocRem.abilitami ();
    panNomPor.abilitami ();
    chkApriFin.setEnabled (true);
    chkSicuro .setEnabled (true);
  } //abilitaFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI)
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("DP_WIN_TITLE"));

    testata.setText (Lingua.frase("DP_TESTATA"));

    labSpiega    .setText (Lingua.frase("DP_INSERT_DATA"));
    labInsReg1   .setText (Lingua.frase("DP_REGISTRATION1"));
    labInsReg2   .setText (Lingua.frase("DP_REGISTRATION2"));
    chkApriFin   .setText (Lingua.frase("DP_OPEN_WIN"));
    chkSicuro    .setText (Lingua.frase("DP_USA_SICUREZZA"));
    botCrea      .setText (Lingua.frase("DP_CREATE"));
    botCanc      .setText (Lingua.frase("DP_CANCEL"));

    chkApriFin.setToolTipText (Lingua.frase("DP_TIP_CHKAPRIFIN"));
    chkSicuro .setToolTipText (Lingua.frase("DP_TIP_CHKSECURE"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {
    protected DefPlace mioDefPlace;

    public ListBottoni (DefPlace mioDefPlace) {
      this.mioDefPlace = mioDefPlace;
    } //costruttore

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (! azione.equals("Annulla")) {
        // Prelevo i parametri dalla GUI e li passo a
        // un THREAD apposta che esegue la creazione.
        // Questo per NON bloccare il gestore degli eventi e 
        // la GUI nel caso che la "creazione" impiegasse
        // un tempo troppo lungo.
        String domNome    = panLocRem.cheNomeDom();
        String placeNome  = panNomPor.cheNome();
        String placePorta = panNomPor.chePortaStr();
        String regAddr    = panLocRem.cheIndirIP();
        String regPorta   = panLocRem.chePorta();
        final boolean apriFin = chkApriFin.isSelected();
        boolean usaSicurezza = chkSicuro.isSelected();

        try {

          final String invocazione = Creatore.invocaPlace (domNome, placeNome, placePorta, regAddr, regPorta, usaSicurezza);

          // CREA E AVVIA IL THREAD 
          // E` un thread che esegue le chiamate a {@link SOMA.gui.Creatore#crea()},
          // {@link SOMA.gui.Creatore#salvaConfigPlace()} e {@link SOMA.gui.ActionPlace.start()}.
          // Viene usato un THREAD SEPARATO in modo che si esegua il codice (che pu impiegare
          // un certo tempo - non trascurabile - per eseguire) evitando in ogni caso di 
          // bloccare la gestione degli eventi e il ritracciamento della GUI.
          // Nota Bene: nel LAB2 della nostra facolt la prima (e solo la prima) creazione
          // di un place tiene il processo "bloccato" (misteriosamente) per ben 60-70 secondi!
          Thread piccoloCreatoreArrakis = new Thread ("piccoloCreatore") {
                public void run() {

                  mioDefPlace.disabilitaFinestra();
                  if (finGenitore != null)
                    finGenitore.abilitaFinestra();

                  try {

                    // CREA L'AMBIENTE <====
                    final Environment env = Creatore.crea (invocazione, anagrafe);
                    
                    // Se sono qui,  andato tutto bene!
                    Creatore.salvaConfigPlace (invocazione, advanced);    // SALVA l'INVOCAZIONE su disco

                    AdvConfig.defAnagrafeFutura (anagrafe);

                    // ORA FARO' ESEGUIRE IL CODICE CHE INFLUENZA LA GUI
                    // IN UN ULTERIORE THREAD SEPARATO, CHE PERO' NON VERRA' 
                    // INVOCATO SUBITO, MA A CHIAMARLO CI PENSERA' IL 
                    // GESTORE DEGLI EVENTI AL MOMENTO GIUSTO!
                    SwingUtilities.invokeLater (new Runnable () {
                            public void run () {
                              if (apriFin) {                           // Apro eventualmente la finestra del place

                                try {
                                  env.actionPlace.start();             // Apre la finestra (invoca l'ActionPlace di Env)
                                }
                                catch (Exception ecc) { OiDialogoi.mostraErrore (ecc); }
                              }
                              if ((! advanced) && (finGenitore != null))
                                finGenitore.distruggiFinestra();       // Se sono in config. NON avanzata, distruggo la finestra ("Inizio")
                              mioDefPlace.distruggiFinestra();         // In ogni caso distruggo questa finestra
                            } //run
                    }); //invokeLater

                  }
                  catch (Exception ecceziunale) {
                    if (finGenitore != null)
                      finGenitore.disabilitaFinestra();  // Ridisabilito la fin. genitore
                    OiDialogoi.mostraErrore (ecceziunale, mioDefPlace.mioFrame);
                    mioDefPlace.abilitaFinestra();
                    mioDefPlace.inPrimoPiano();
                  } //catch
                } //run
          }; //esecutore (Thread)
          piccoloCreatoreArrakis.start();
          OiDialogoi.mostraMessaggio (Lingua.frase("DP_CREATING"), mioFrame);
        }
        catch (Exception eccez) {
          OiDialogoi.mostraErrore (eccez, mioFrame);
        }
      } //if
      else  // in ogni caso considera un "Annulla"
        mioDefPlace.distruggiFinestra();   // In ogni caso distruggo questa finestra
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      mioDefPlace.distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

} //DefPlace