/**  Apparenza
 *     Classe "statica" per migliorare la gestione di UIManager.
 *     Contiene la parte di interfaccia grafica per far scegliere 
 *     all'utente l'apparenza (look & feel) da usare.
 *     @author     Luigi Antenucci
 *     @version    3.2
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.io.File;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class Apparenza {

  // Costanti (pubbliche):
      /**
       *  Il "Look & Feel" da usare per default (al primo lancio): il MIO!
       */
//  public static final String APPARENZA_DEFAULT = "SOMA"+File.separator+"gui"+File.separator+"gigi"+File.separator+"GigiLookAndFeel";
    public static final String APPARENZA_DEFAULT = "javax.swing.plaf.metal.MetalLookAndFeel";

  // Variabili protette:
      /**
       *  Tengo traccia se  la prima volta che si esegue un metodo di questa classe.
       *  Infatti la "prima volta" - e solo in quell'occasione - va caricato il file di lingua.
       */
  protected static boolean primaVolta = true;

      /**
       *  Indica qual  il look and feel attuale. Utile per non impostare nuovamente lo stesso.
       */
  protected static String LookFeelAttuale = "";


      /**
       *  Carico il file di lingua di questa classe
       */
  protected static void CaricaMiaLingua () {
    if (primaVolta) {
      Lingua.caricaFileDiLingua (Apparenza.class);
      primaVolta=false;
    }
  } //CaricaMiaLingua

      /**
       *  Definisce l'apparenza (il "Look & Feel", che io ho ribattezzato "apparenza") 
       *  da usare.  Invoca direttamente il metodo {@link javax.swing.UIManager#setLookAndFeel()}
       *  che pu lanciare eventi di "cambio di propriet".
       *  Vedi {@link SOMA.gui.Finestra#propertyChange()}
       */
  public static void defApparenza (String LookFeel) {
    // IMPOSTA L'APPARENZA CORRENTE (USA L'UIManager)
    if (! LookFeel.equals(LookFeelAttuale)) {
      try {

        UIManager.setLookAndFeel (LookFeel);      // IMPOSTA IL LOOK & FEEL

      } 
      catch (Exception eccezione) { 
        OiDialogoi.mostraErrore (eccezione);
      }
      LookFeelAttuale = LookFeel;
    }
  } //defApparenza

      /**
       *  Rende l'elenco (sottoforma di array di stringhe) di tutte le CLASSI
       *  delle apparenze (Look-and-Feel) installate.
       */
  public static String[] cheElencoClassiApparenze () {
    // Prendo i L&F installati
    UIManager.LookAndFeelInfo[] LAFinfo = UIManager.getInstalledLookAndFeels();

    String[] Tmp = new String [LAFinfo.length];
    for (int i=0; i < LAFinfo.length; i++)
      Tmp[i] = new String (LAFinfo[i].getClassName());  // Prelevo il nome della classe
    return Tmp;
  } //cheElencoClassiApparenze

      /**
       *  Rende l'elenco (sottoforma di array di stringhe) di tutti i NOMI 
       *  delle apparenze (Look-and-Feel) installate.
       */
  public static String[] cheElencoNomiApparenze () {
    // Prendo i L&F installati
    UIManager.LookAndFeelInfo[] LAFinfo = UIManager.getInstalledLookAndFeels();

    String[] Tmp = new String [LAFinfo.length];
    for (int i=0; i < LAFinfo.length; i++)
      Tmp[i] = new String (LAFinfo[i].getName());  // Prelevo il nome della classe
    return Tmp;
  } //cheElencoNomiApparenze

      /**
       *  Apre una finestra in cui l'utente pu scegliere l'apparenza da usare.
       *  Una volta scelta l'apparenza, viene automaticamente invocato {@link SOMA.gui.Apparenza.#defApparenza()}
       *  che provveder a generare un evento di "cambioApparenza" (cambio di 
       *  propriet, per l'esattezza) se necessario.
       */
  public static void finestraSceltaApparenza () {
    finestraSceltaApparenza (null);
  } //finestraSceltaApparenza

      /**
       *  Apre una finestra ("modale" col JFrame passato) in cui l'utente pu 
       *  scegliere l'apparenza da usare.
       *  Una volta scelta l'apparenza, viene automaticamente invocato {@link SOMA.gui.Apparenza.#defApparenza()}
       *  che provveder a generare un evento di "cambioApparenza" (cambio di 
       *  propriet, per l'esattezza) se necessario.
       */
  public static void finestraSceltaApparenza (JFrame frameGenitore) {
    // Apre una finestra "dialog" (modale) in cui permette all'utente 
    // di scegliere l'apparenza da usare.
    // Una volta scelta, invoca automaticamente la "defApparenza".
    if (primaVolta) 
      CaricaMiaLingua ();
    String[] arrApparNomi  = cheElencoNomiApparenze();
    String[] arrApparClass = cheElencoClassiApparenze();
    String apparAtt = UIManager.getLookAndFeel().getName();
    ImageIcon iconetta = new ImageIcon(Finestra.PICTURE_PATH+"ApparenzaImg.gif");
    int L = JOptionPane.showOptionDialog 
                 (frameGenitore,
                  Lingua.frase("APPARENZA_CHOOSE_LOOK"),
                  Lingua.frase("APPARENZA_WIN_TIT"),
                  JOptionPane.DEFAULT_OPTION,
                  JOptionPane.QUESTION_MESSAGE,
                  iconetta,
                  arrApparNomi,   // le opzioni sono le stringhe delle apparenze
                  apparAtt);      // evidenzio (ma NON seleziono) quella attualmente in uso
    if ((L >= 0) && (L < arrApparNomi.length)) {
      defApparenza (arrApparClass[L]);  //NB: qui uso "class"
    }
  } //finestraSceltaApparenza

      /**
       *  Rende un oggetto {@link javax.swing.JMenu} che, una volta inserito in
       *  una finestra {@link javax.swing.JFrame}, permette all'utente di
       *  cambiare l'apparenza in modo "dinamico".
       *  Il men contiene dei bottoni "radio" (uno per ogni apparenza) e una voce
       *  che invoca la {@link SOMA.gui.Apparenza#finestraSceltaApparenza()}.
       *  La selezione di un bottone "radio" causa la chiamata a {@link SOMA.gui.Apparenza.#defApparenza()}.
       */
  public static JMenu menuSceltaApparenza () {
    return menuSceltaApparenza (null);
  } //menuSceltaApparenza

      /**
       *  Analoga alla {@link SOMA.gui.Apparenza#menuSceltaApparenza()}.
       *  Il {@link javax.swing.JFrame} serve per quando si va ad aprire la
       *  finestra di dialogo per la scelta dell'apparenza.
       */
  public static JMenu menuSceltaApparenza (final JFrame frameGenitore) {
    // Costruisce un men con la scelta di tutte le possibili apparenze.
    // Se l'utente ne selezioner una, verr invocata la "defApparenza".
    if (primaVolta) 
      CaricaMiaLingua ();
    String Mnemonici = Lingua.frase("APPARENZA_MNEMONICS");

    String[] arrApparNomi  = cheElencoNomiApparenze();
    String[] arrApparClass = cheElencoClassiApparenze();
    String appClassAtt = UIManager.getLookAndFeel().getClass().getName();  // qui la classe
    JMenu scelta = new JMenu (Lingua.frase("APPARENZA_VOCE_MENU"));
    scelta.setMnemonic(Mnemonici.charAt(0));
    ActionListener mioListCambio = new ActionListener() {
                                          public void actionPerformed (ActionEvent e) {
                                            defApparenza (e.getActionCommand());
                                          }};
    ButtonGroup gruppo = new ButtonGroup();     // Mi serve un gruppo di bottoni
    JRadioButtonMenuItem item;
    for (int i=0; i < arrApparNomi.length; i++) {
      item = new JRadioButtonMenuItem (arrApparNomi[i]);
      item.setSelected (arrApparClass[i].equals(appClassAtt));
      item.setToolTipText (arrApparClass[i]);
      item.setActionCommand(arrApparClass[i]);  // NB: nel comando c'e' il nome "classe"
      item.addActionListener (mioListCambio);
      gruppo.add (item);
      scelta.add (item);
    } //for

    scelta.addSeparator();

    JMenuItem item2 = new JMenuItem (Lingua.frase("APPARENZA_VOCE_SCEGLI"));
    item2.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"ApparenzaIco.gif"));
    item2.setMnemonic(Mnemonici.charAt(1));
    item2.setActionCommand("");
    item2.addActionListener ( new ActionListener() {
                                public void actionPerformed(ActionEvent e) {
                                    SwingUtilities.invokeLater (new Runnable () {
                                            public void run () {
                                              finestraSceltaApparenza (frameGenitore);
                                            } //run
                                    }); //invokeLater
                                }} );
    scelta.add (item2);

    scelta.addSeparator();

    item2 = new JMenuItem (Lingua.frase("APPARENZA_VOCE_PACK"));
    item2.setActionCommand("pacca");
    item2.setIcon (new ImageIcon(Finestra.PICTURE_PATH+"FinAdjust.gif"));
    item2.addActionListener ( new ActionListener() {
                                public void actionPerformed(ActionEvent e) {
                                    SwingUtilities.invokeLater (new Runnable () {
                                            public void run () {
                                              frameGenitore.pack();
                                            } //run
                                    }); //invokeLater
                                }} );
    scelta.add (item2);

    return scelta;   // Rende la voce di men
  } //menuSceltaApparenza

} //Apparenza