package SOMA.explorer;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class LoadScriptActionListener implements ActionListener
{
  Frame parentFrame;
  String title;
  DirExplorerItem dir;
  PrintStream out;
  public String loadScriptDirectory = "";

  public LoadScriptActionListener( Frame parentFrame, String title, DirExplorerItem dir, PrintStream out )
  {
    this.parentFrame = parentFrame;
    this.title = title;
    this.dir = dir;
    this.out = out;
  }

  public void actionPerformed(ActionEvent e)
  {
    FileDialog fileDialog = new FileDialog( parentFrame, title, FileDialog.LOAD );

    fileDialog.setDirectory( loadScriptDirectory );
    fileDialog.show();

    String file = fileDialog.getFile();

    if( file != null )
    {
      try
      {
        new ExplorerThread(
          dir,
          new FileInputStream( new File( fileDialog.getDirectory(), file ) ),
          out,
          true ).start();
      }
      catch( Exception f )
      {
        f.printStackTrace( out );
      }

      loadScriptDirectory = fileDialog.getDirectory();
    }
  }
}