package SOMA.explorer;

import SOMA.security.auth.*;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;

import java.io.*;

import java.security.*;
import javax.security.auth.*;
import javax.security.auth.login.*;
import javax.security.auth.callback.*;

/**
 *
 * @author  Mario Zambrini
 * @version
 */
public class ExplorerThreadGUI extends javax.swing.JFrame implements Runnable {

  // Struttura ad albero

  private DirExplorerItem root;
  private DefaultTreeModel treeModel;
  private ExplorerTreeSelectionListener explorerTreeSelectionListener;

  // Pipe per intercettare l'output e mandarlo sulla TextArea
  // Per ora l'output lo mando a System.out

  /**
  private PipedOutputStream pos=new PipedOutputStream();
  private PrintStream out=new PrintStream(pos,true);
  private PipedInputStream pis;
  private InputStreamReader isr;
  private BufferedReader br;
  */

  // Autenticazione

  private LoginContext lc;
  private Subject somaUser;
  private SomaUserCallbackHandler somaUserCallbackHandler;

  /** Initializes the Form */
  public ExplorerThreadGUI(DirExplorerItem root) {
    initComponents ();
    pack ();

    this.root=root;

  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    setTitle ("Soma");
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
          exitForm (evt);
        }
      }
    );
    getContentPane ().setLayout (new java.awt.BorderLayout ());

    somaMenuBar = new javax.swing.JMenuBar ();
      jMenu1 = new javax.swing.JMenu ();
      jMenu1.setText ("Soma");
        logonSomaMenu = new javax.swing.JMenuItem ();
        logonSomaMenu.setText ("Logon");
        logonSomaMenu.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
              logonSomaMenuActionPerformed (evt);
            }
          }
        );
        jMenu1.add(logonSomaMenu);

        logoutSomaMenu = new javax.swing.JMenuItem ();
        logoutSomaMenu.setEnabled (false);
        logoutSomaMenu.setText ("Logout");
        logoutSomaMenu.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
              logoutSomaMenuActionPerformed (evt);
            }
          }
        );
        jMenu1.add(logoutSomaMenu);

      somaMenuBar.add(jMenu1);


    setJMenuBar(somaMenuBar);
    explorerScrollPane = new javax.swing.JScrollPane ();

      explorerTree = new javax.swing.JTree ();

    explorerScrollPane.setViewportView (explorerTree);
    getContentPane ().add (explorerScrollPane, "North");

    outputScrollPane = new javax.swing.JScrollPane ();

      outputTextArea = new javax.swing.JTextArea ();

    outputScrollPane.setViewportView (outputTextArea);
    getContentPane ().add (outputScrollPane, "Center");

    syntaxPanel = new javax.swing.JPanel ();
    syntaxPanel.setLayout (new java.awt.BorderLayout ());

      syntaxLabel = new javax.swing.JLabel ();
      syntaxLabel.setText ("Description:");
      syntaxPanel.add (syntaxLabel, "Center");

      executeButton = new javax.swing.JButton ();
      executeButton.setText ("Execute");
      executeButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            executeButtonActionPerformed (evt);
          }
        }
      );
      syntaxPanel.add (executeButton, "East");

    getContentPane ().add (syntaxPanel, "South");

  }//GEN-END:initComponents

    /** Quando l'utente clicca execute, verifico la voce selezionata,
        chiedo i parametri e lancio l'esecuzione del comando legando al
        codice il soggetto autenticato.
        Al termine ricostruisco l'abero con le eventuali nuove voci sempre
        legando la chiamata al soggetto autenticato, in modo da mostrare solo
        le voci di menu' relativo al ruolo assunto dal soggetto.
    */

  private void executeButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_executeButtonActionPerformed

    String parameters;

    TreePath pathToNode=explorerTree.getSelectionPath();
    ExplorerTreeNode node=(ExplorerTreeNode)pathToNode.getLastPathComponent();
    parameters=JOptionPane.showInputDialog(this,node.getKey()+" "+node.getSyntax(),"Enter Parameters for Command:",JOptionPane.QUESTION_MESSAGE);
    Subject.doAs(somaUser, new ExecutePrivilegedAction(parameters,node));
    Subject.doAs(somaUser, new TreePrivilegedAction());

  }//GEN-LAST:event_executeButtonActionPerformed

    /** Quando l'utente esce dal sistema, effettuo il logout,
        elimino l'albero e riattivo le voci di menu corrette.
    */

  private void logoutSomaMenuActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_logoutSomaMenuActionPerformed

    try {

      lc.logout();

    } catch (LoginException ex) {

      ex.printStackTrace();

    }


    treeModel.setRoot(new DefaultMutableTreeNode("/"));
    treeModel.reload();
    explorerTree.removeTreeSelectionListener(explorerTreeSelectionListener);

    syntaxLabel.setText("Description:");

    logonSomaMenu.setEnabled(true);
    logoutSomaMenu.setEnabled(false);
    executeButton.setEnabled(false);

  }//GEN-LAST:event_logoutSomaMenuActionPerformed

    /** Quando l'utente tenta di loggarsi eseguo l'autenticazione
      e poi costruisco l'albero in modo condizionato al soggetto
      autenticato.
    */

  private void logonSomaMenuActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_logonSomaMenuActionPerformed

    // Logon  (JAAS)

    try {
      somaUser=new Subject();
      somaUserCallbackHandler=new SomaUserCallbackHandler();
      lc = new LoginContext("Soma",somaUser,somaUserCallbackHandler);
    } catch (LoginException le) {
      le.printStackTrace();
      System.exit(-1);
    }

    // the user has 3 attempts to authenticate successfully
    int i;
    for (i = 0; i < 3; i++) {
      try {
        // attempt authentication
        lc.login();

        // if we return with no exception, authentication succeeded
        break;

      } catch (AccountExpiredException aee) {

        JOptionPane.showMessageDialog(this,"Your account has expired. Please notify your administrator.","Login Failed",JOptionPane.WARNING_MESSAGE);
        System.exit(-1);

      } catch (CredentialExpiredException cee) {

        JOptionPane.showMessageDialog(this,"Your credentials have expired.","Login Failed",JOptionPane.WARNING_MESSAGE);
        System.exit(-1);

      } catch (FailedLoginException fle) {

        JOptionPane.showMessageDialog(this,"Authentication Failed","Login Failed",JOptionPane.WARNING_MESSAGE);

      } catch (Exception e) {

        JOptionPane.showMessageDialog(this,"Unexpected Exception - unable to continue","Login Failed",JOptionPane.WARNING_MESSAGE);
        e.printStackTrace();
        System.exit(-1);
      }

    }

    // did they fail three times?
    if (i == 3) {
      JOptionPane.showMessageDialog(this,"Sorry","Login Failed",JOptionPane.WARNING_MESSAGE);
      System.exit(-1);
    }

    // Construisco l'albero con le voci di men

    Subject.doAs(somaUser,new TreePrivilegedAction());
    explorerTreeSelectionListener=new ExplorerTreeSelectionListener();
    explorerTree.addTreeSelectionListener(explorerTreeSelectionListener);

    // Disabilito la voce logon e abilito la voce logout

    logonSomaMenu.setEnabled(false);
    logoutSomaMenu.setEnabled(true);
  }//GEN-LAST:event_logonSomaMenuActionPerformed

  /** Exit the Application */
  private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
    System.exit (0);
  }//GEN-LAST:event_exitForm


// Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JScrollPane explorerScrollPane;
  private javax.swing.JScrollPane outputScrollPane;
  private javax.swing.JPanel syntaxPanel;
  private javax.swing.JTree explorerTree;
  private javax.swing.JTextArea outputTextArea;
  private javax.swing.JLabel syntaxLabel;
  private javax.swing.JButton executeButton;
  private javax.swing.JMenuBar somaMenuBar;
  private javax.swing.JMenu jMenu1;
  private javax.swing.JMenuItem logonSomaMenu;
  private javax.swing.JMenuItem logoutSomaMenu;
// End of variables declaration//GEN-END:variables


  public void run() {

    this.setSize(600,600);
    this.show();

    // Mando in esecuzione il thread che intercetta l'output

    /*
    try {

      pis=new PipedInputStream(pos);
      isr=new InputStreamReader(pis);
      br=new BufferedReader(isr);

    } catch (IOException ex) {

      ex.printStackTrace();

    }

    OutputThread outputThread=new OutputThread(br);
    outputThread.start();
    */

    // Inizializzo l'albero vuoto

    treeModel=new DefaultTreeModel(new DefaultMutableTreeNode("/"));
    explorerTree.setModel(treeModel);
    explorerTree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
    explorerTree.setCellRenderer(renderer);

  }

  class ExplorerTreeSelectionListener implements TreeSelectionListener {

    // Ogni volta che viene selezionata una voce di men
    // visualizzo la sintassi

    public void valueChanged(TreeSelectionEvent e) {

      ExplorerTreeNode selectedNode;

      selectedNode=(ExplorerTreeNode)e.getPath().getLastPathComponent();
      syntaxLabel.setText("Description: "+selectedNode.getKey()+" "+selectedNode.getSyntax());
      executeButton.setEnabled(true);

    }

  }

  // Thread che intercetta l'output e lo redireziona
  // sulla TextArea

  class OutputThread extends Thread {

    BufferedReader in;

    public OutputThread(BufferedReader in) {

      super("OutputThread");
      this.in=in;

    }

    public void run() {

      String outputText;

      while (true) {

        try {

          outputText=in.readLine();
          outputTextArea.append(outputText+"\n");
          int max=outputScrollPane.getVerticalScrollBar().getMaximum();
          outputScrollPane.getVerticalScrollBar().setValue(max);

        } catch (IOException ex) {

          ex.printStackTrace();
          break;

        }

      }

    }

  }

  class ExecutePrivilegedAction implements PrivilegedAction {

    String parameters;
    ExplorerTreeNode node;

    public ExecutePrivilegedAction(String parameters,ExplorerTreeNode node) {

      this.parameters=parameters;
      this.node=node;

    }

    public Object run() {

      node.execute(parameters,System.out);
      treeModel.setRoot(new ExplorerTreeNode(ExplorerThreadGUI.this.root));
      treeModel.reload();

      return null;

    }

  }

  class TreePrivilegedAction implements PrivilegedAction {

    public Object run() {

      treeModel.setRoot(new ExplorerTreeNode(root));
      treeModel.reload();

      return null;

    }

  }

  class SomaUserCallbackHandler implements CallbackHandler {

    public void handle(Callback[] callbacks) throws IOException,UnsupportedCallbackException {

      for (int i = 0; i < callbacks.length; i++) {

        if (callbacks[i] instanceof TextOutputCallback) {

          // display the message according to the specified type
          TextOutputCallback toc = (TextOutputCallback)callbacks[i];
          switch (toc.getMessageType()) {
            case TextOutputCallback.INFORMATION:
              JOptionPane.showMessageDialog(ExplorerThreadGUI.this,toc.getMessage(),"Information:",JOptionPane.INFORMATION_MESSAGE);
              break;
            case TextOutputCallback.ERROR:
              JOptionPane.showMessageDialog(ExplorerThreadGUI.this,toc.getMessage(),"Error:",JOptionPane.ERROR_MESSAGE);
              break;
            case TextOutputCallback.WARNING:
              JOptionPane.showMessageDialog(ExplorerThreadGUI.this,toc.getMessage(),"Warning:",JOptionPane.WARNING_MESSAGE);
              System.out.println("WARNING: " + toc.getMessage());
              break;
            default:
              throw new IOException("Unsupported message type: " + toc.getMessageType());
          }

        } else if (callbacks[i] instanceof NameCallback) {

          // prompt the user for a username
          NameCallback nc = (NameCallback)callbacks[i];

          String userName;
          userName=JOptionPane.showInputDialog(ExplorerThreadGUI.this,nc.getPrompt(),"SOMA Logon",JOptionPane.QUESTION_MESSAGE);
          nc.setName(userName);

        } else if (callbacks[i] instanceof PasswordCallback) {

          // prompt the user for sensitive information
          PasswordCallback pc = (PasswordCallback)callbacks[i];
          String password;
          password=JOptionPane.showInputDialog(ExplorerThreadGUI.this,pc.getPrompt(),"SOMA Logon",JOptionPane.QUESTION_MESSAGE);

          int pwdlen=password.length();
          char[] pwd=new char[pwdlen];
          password.getChars(0,pwdlen,pwd,0);
          pc.setPassword(pwd);


        } else if (callbacks[i] instanceof ChoiceCallback) {

          // Chiedo all'utente i ruoli che vuole assumere

          ChoiceCallback cc = (ChoiceCallback)callbacks[i];
          RoleSelectionDialog roleSelectionDialog;
          roleSelectionDialog=new RoleSelectionDialog(ExplorerThreadGUI.this,true,cc.getChoices());
          roleSelectionDialog.show();
          cc.setSelectedIndexes(roleSelectionDialog.getindexes());

        } else {
         throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }

      }

    }

  }

}
