package SOMA.explorer;

import java.io.*;
import java.util.*;

/** Classe astratta che rappresenta una voce di menu.
* E' necessario ridefinire il metodo {@link #Execute( Collection Parameters, PrintStream out )} che specifica il comportamento
* della voce di menu.
*
* @author Livio Profiri
*/
public abstract class ExplorerItem implements Serializable
{
  /** <B>Sintassi</B>: stringa di descrizione della voce di menu.
  *
  * Viene visualizzata dal comando {@link SOMA.explorer.DirExplorerItem#PrintDirectory( PrintStream )},
  * accanto al nome della voce di menu.<BR>
  * E' accessibile tramite i metodi {@link #getSyntax() getSyntax()} e {@link #setSyntax( String Syntax ) setSyntax( String Syntax )}.
  *
  * @serial
  */
  protected String Syntax;  // Protected perch non voglio che si acceda direttamente
                            // al campo Syntax, si devono utilizzare getSyntax() e setSyntax()
                            // che, eventualmente ridefiniti nelle sottoclassi possono attribiure comportamenti
                            // diversi...
                            // Esempio: ObjectExplorerItem chiama oggetto.toString() per visualizzare la sintassi.
                            // Esempio: Network.Connection.DaemonExplorerItem  visualizza lo stato del demone...

  /** Crea una nuova voce di menu specificandone la sintassi. */
  public ExplorerItem( String Syntax )
  {
    this.Syntax = Syntax;
  }

  /** Crea una nuova voce di menu senza specificarne la sintassi. */
  public ExplorerItem()
  {
    Syntax = "Abstract ExplorerItem";
  }

  /** Esegue la voce di menu con i parametri specificati.
  *
  * Questo e' il metodo che va ridefinito per creare un ExplorerItem non astratto.
  * Esempio: {@link SOMA.explorer.LoadExplorerItem}
  *
  * @param Parameters parametri da utilizzare nell'esecuzione.
  * @param out PrintStream a cui inviare l'output.
  *
  * @return un Object risultato della computazione eseguita.
  */
  public abstract Object Execute( Collection Parameters, PrintStream out );

  /** Esegue la voce di menu con i parametri specificati, inviando l'output a System.out. */
  public Object Execute( Collection  Parameters )
  {
    return Execute( Parameters, System.out );
  }

  /** Stampa un messaggio di descrizione sul PrintStream specificato.
  * Questo metodo viene eseguito invocando il comando <I>help</I>
  */
  public String Help( PrintStream out )
  {
    out.println( Syntax );
    return Syntax;
  }

  /** Stampa un messaggio di descrizione su System.out.
  * Questo metodo viene eseguito invocando il comando <I>help</I>
  */
  public String Help()
  {
    return Help( System.out );
  }

  /** In questa implementazione restuisce {@link #Syntax Syntax}*/;
  public String toString()
  {
    return Syntax;
  }

  /** Restituise {@link #Syntax Syntax}, descrizione della voce di menu.
  *
  * Se ridefinisco questo metodo posso cambiare dinamicamente la "sintassi":<BR>
  *   Vedi ad ex: {@link SOMA.explorer.ObjectExplorerItem} -> la sintassi  una descrizione dello stato dell'oggetto.<BR>
  *
  * Infatti {@link SOMA.explorer.DirExplorerItem DirExplorerItem} usa questo metodo per stabilire cosa scrivere
  * accanto alla voce di menu.<BR>
  */
  public String getSyntax()
  {
    return Syntax;
  }

  /** Modifica il valore di {@link #Syntax} restiuendo il valore precedente.*/
  public String setSyntax( String Syntax )
  {
    String oldSyntax = this.getSyntax();
    this.Syntax = Syntax;

    return oldSyntax;
  }
}