package SOMA.agent.mobility;

import SOMA.agent.*;
import SOMA.naming.*;
import SOMA.Environment;

import java.util.*;
import java.io.PrintStream;

/** Struttura dati che contiene i {@link SOMA.agent.AgentWorker worker}
* dell'{@link SOMA.agent.mobility.AgentManager AgentManager}.
*
* @author Livio Profiri (metodo aggiunto da Luigi Antenucci)
*/
public class AgentWorkerStore
{
  private Hashtable workers = new Hashtable();

  public AgentWorker getWorker( AgentID agentID )
  {
    return (AgentWorker)workers.get( agentID );
  }

  // Attenzione: si dovrebbero prendere provvedimenti se il worker era ancora l e attivo.
  public AgentWorker putWorker( AgentWorker worker )
  {
    AgentWorker old = (AgentWorker)workers.put( worker.agent.getID(), worker );

    if( old != null )
      System.err.println( "ERRORE: sostituito il worker " + old + " non ancora eliminato" );

    return old;
  }

  public AgentWorker removeWorker( AgentID agentID )
  {
    return (AgentWorker)workers.remove( agentID );
  }

  public void printWorkers( PrintStream out )
  {
    Iterator i = workers.entrySet().iterator();
    for( int j = 1; i.hasNext(); j++ )
    {
      Map.Entry e = (Map.Entry)i.next();
      out.println( "  " + j + ") " + e.getKey() + " --> " + e.getValue() );
    }
  }

  public List saveWorkers( Environment env )
  {
    List list = new LinkedList();

    Iterator i = workers.entrySet().iterator();

    env.out.println( "AgentWorkerStore: Saving workers:" );
    for( int j = 1; i.hasNext(); j++ )
    {
      Map.Entry e = (Map.Entry)i.next();

      try
      {
        SavedWorker saved = new SavedWorker( env, (AgentWorker)e.getValue() );
        list.add( saved );
        env.out.println( "  " + j + ") " + saved );
      }
      catch( Exception f )
      {
        env.out.println( "  " + j + ") ERROR: " + f );
      }
    }
    env.out.println();

    return list;
  }

  /** Restituisce il numero di worker e quindi di agenti del place. */
  public int workersNumber()
  {
    return workers.size();
  }

  /** 
   *  Rende un array di AgentID corrispondente all'elenco di tutti gli agenti 
   *  gestiti da worker nel place corrente.
   *  Metodo aggiunto da Luigi Antenucci per la "ManipolaAgenti".
   */
  public AgentID[] cheElencoAgenti () {
    Set elencoAgID = workers.keySet();
    return (AgentID[]) elencoAgID.toArray (new AgentID[workers.size()]);
  } //cheElencoAgenti

}