package SOMA.agent.classLoading;

import java.security.*;
import java.security.cert.Certificate;
import java.io.*;
import java.util.*;
import java.security.Principal;
import java.net.*;

import iaik.x509.X509Certificate;

import SOMA.security.*;
import SOMA.Environment;
import SOMA.naming.*;
import SOMA.utility.*;
import SOMA.security.infrastructure.entrust.EntrustToSoma;

public class AgentClassLoaderSecurity extends AgentClassLoader
{/*
  Environment env;
  CodeSource codeSource;
  AgentID agentID;
  Set loadedClassesSet = new TreeSet();
*/

  // costruttore necessario per la creazione dell'agente la prima volta.
  public AgentClassLoaderSecurity( Environment env, String agentClass, AgentID agentID , boolean sw )
            throws SignatureVerifyException
  {
    super();

    this.env = env;
    this.agentID = agentID;

    System.out.println( "             codesource: " + AgentToURL( agentClass, agentID ));
    System.out.println( "        distinguishname: " + ((AgentIDSigned)agentID).x509.getSubjectDN().getName() );

    // Metto anche l'ID cos ho un CodeSource diverso per ogni classLoader
    // Portei fornire permessi specifici per un agente, dato il suo ID
    codeSource = new CodeSource( AgentToURL( agentClass, agentID ),
                                 new Certificate[0] );
  }




  public AgentClassLoaderSecurity( Environment env, String agentClass, AgentID agentID )
            throws SignatureVerifyException
  {
    super();

    this.env = env;
    this.agentID = agentID;

    //if (agentID instanceof AgentIDSigned && ((AgentIDSigned)agentID).x509 != null)
    //  if ( ((AgentIDSigned)agentID).verifyState((SecurityEnvironment)env) )
    //  throw new SignatureVerifyException("Verifica firma codice");

    // Metto anche l'ID cos ho un CodeSource diverso per ogni classLoader
    // Portei fornire permessi specifici per un agente, dato il suo ID
    System.out.println( "             codesource: " + AgentToURL( agentClass, agentID ));
    System.out.println( "        distinguishname: " + (new EntrustToSoma()).getAgentPrincipal(
                     ((AgentIDSigned)agentID).x509.getSubjectDN().getName() ) );


    codeSource = new CodeSource( AgentToURL( agentClass, agentID ),
                                 new Certificate[0] );
  }

  public static URL AgentToURL( String AgentClass, AgentID agentID )
  {
    try
    {
      //PlaceID pID = new PlaceID ( agentID.x509.getSubjectDN().getName() );
      //mettere anonymous nel Soma.policy per l'accesso anonimo

      return ( ( agentID instanceof AgentIDSigned && ((AgentIDSigned)agentID).x509 != null ) ?
                 ( new URL( "http:/" + (new EntrustToSoma()).getAgentPrincipal(
                                         ((AgentIDSigned)agentID).x509.getSubjectDN().getName() ) +
                                  "/" + agentID.place.domain +
                                  "/" + agentID.place.place +
                                  "/" + AgentClass +
                                  "/" + agentID.ID )) :
                 ( new URL( "http://anonymous" +
                                  "/" + agentID.place.domain +
                                  "/" + agentID.place.place +
                                  "/" + AgentClass +
                                  "/" + agentID.ID )) );
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
    return null;
  }

  protected Class findClass(final String className) throws ClassNotFoundException
  {
    try
    {
      return (Class)AccessController.doPrivileged(
        new PrivilegedExceptionAction()
          {
            public Object run() throws Exception
            {
              return myFindClass( className );
            }
          });
    }
    catch( PrivilegedActionException e )
    {
      throw new ClassNotFoundException( "AgentClassManager.findClass: Exception on Class " + className,
                                        e.getException() );
    }
  }

  private Class myFindClass( String className)
                throws Exception, SignatureVerifyException
  {
    Class theClass = null;
    /*
    env.err.println();
    env.err.println( "FindClass " + className );
    env.err.println();
    */

    // Attenzione: bruttino: il primo che finisce esce!
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // Stabilisco che la classe si trovi nella home dell'agente

    if( agentID.getHome().equals( env.placeID ) )
    {
      try // Carico dalla directory agents
      {
        byte[] classData = env.agentManager.agentClassManager.loadClassFile( className );

        System.out.println (" sono nella prima verify");

        // verifica le firme
        if (! verifyCode (agentID, env,  className, classData)) return null;
        if (! verifyState(env)) return null;

        theClass = defineClass( className, classData, 0, classData.length, codeSource );
      }
      catch( Exception f ) // Carico dalla directory cache
      {
        byte[] classData = env.agentManager.cacheClassManager.loadClassFile( className );

        if (!  verifyCode( agentID, env, className, classData )) return null;
        //if (!  verifyState((SecurityEnvironment)env) ) return null;

        theClass = defineClass( className, classData, 0, classData.length, codeSource );
      }
    }
    else
    {
      try // Carico dalla directory cache
      {
        byte[] classData = env.agentManager.cacheClassManager.loadClassFile( className );

        if (! verifyCode (agentID, env,  className, classData)) return null;
        //if (! verifyState(env)) return null;

        theClass = defineClass( className, classData, 0, classData.length, codeSource );
      }
      catch( Exception f ) // Carico dal place di origine.
      {
        theClass = findFromRemote( className );
      }
    }

    loadedClassesSet.add( className );
    return theClass;
  }

  public Class findFromRemote( final String className )
       throws ClassNotFoundException,
              SignatureVerifyException
  {
    WaitAndTimeout syncho = new WaitAndTimeout( 60 * 1000, "class " + className, env.out ); // 60 secondi di timeout

    int synchroIndex = env.agentManager.indexStore.put( syncho );
    int classDataIndex = env.agentManager.indexStore.put( new Object() ); // Semplicemente: faccio posto

    byte[] classData = null;

    try
    {
      env.networkManager.startPermanentConnection( agentID.getHome() );
      if( !env.networkManager.sendCommand(
              agentID.getHome(),
              new ClassRequestCommand( className, env.placeID, classDataIndex, synchroIndex )))
            throw new ClassNotFoundException( "AgentClassManager.findClass: can't send ClassRequestCommand." );

      //env.err.println( Thread.currentThread().toString() + " is going to WAIT on index " + synchroIndex );

      if( syncho.Wait() == WaitAndTimeout.TIMEOUT )
      {
        //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        env.err.println( toString() + "PROBLEMA DI CLASSLOADING. Aspetto 20 secondi prima di lanciare l'eccezione!" );

        synchronized( this )
        {
          try
          {
            wait( 20 * 1000 );
          }
          catch( InterruptedException e )
          {
            e.printStackTrace( env.err );
          }
          env.err.println( toString() + "Ora vado." );
        }

        throw new ClassNotFoundException( "AgentClassManager.findClass: Receive class TIMEOUT EXPIRED." );
      }

      classData = (byte[])env.agentManager.indexStore.get( classDataIndex );
    }
    finally // Faccio le pulizie!
    {
      env.agentManager.indexStore.remove( synchroIndex );
      env.agentManager.indexStore.remove( classDataIndex );
      env.networkManager.stopPermanentConnection( agentID.getHome() );
    }

    if( classData != null )
    {
      final byte[] finalClassData = classData; // Un modo semplice per passare un parametro.

      // Salvo nella cache in background!!!
      Thread saver = new Thread( "[Cache Saver: " + className + "]")
        {
          public void run()
          {
            yield(); // Lo faccio dopo!
            try
            {
              env.agentManager.cacheClassManager.saveClassFile( className, finalClassData );
            }
            catch( Exception e )
            {
              e.printStackTrace();
            }
          }
        };

      saver.setPriority( Thread.MIN_PRIORITY );
      saver.start();
    }

    if (! verifyCode (agentID, env,  className, classData)) return null;
   // if (! verifyState((SecurityEnvironment)env)) return null;

    return defineClass( className, classData, 0, classData.length, codeSource );
  }

  public Set getLoadedClassesSet()
  {
    return loadedClassesSet;
  }

  public String toString()
  {
    return "[AgentClassLoader " + agentID + " <-> " + codeSource + "]";
  }

  boolean verifyCode (AgentID agentID, Environment env, String className, byte [] classData)
  {
        if (agentID instanceof AgentIDSigned && ((AgentIDSigned)agentID).x509 != null &&
           ((AgentIDSigned)agentID).CodeAgentSignature != null )
          return (((AgentIDSigned)agentID).verifyCode((SecurityEnvironment)env, className, classData));

        return true;
  }

  boolean verifyState (Environment env)
  {
        if (agentID instanceof AgentIDSigned && ((AgentIDSigned)agentID).x509 != null &&
           ((AgentIDSigned)agentID).StateAgentSignature != null )
          return (((AgentIDSigned)agentID).verifyState((SecurityEnvironment) env));
        return true;
  }

  /*
  public void finalize()
  {
    env.err.println( "*** FINALIZE " + this + " ***" );
  }*/
}