package SOMA.agent.classLoading;

import java.security.*;
import java.security.cert.Certificate;
import java.io.*;
import java.util.*;
import SOMA.Environment;
import java.net.*;
import SOMA.naming.*;
import SOMA.utility.*;

public class AgentClassLoader extends SecureClassLoader
{
  Environment env;
  CodeSource codeSource;
  AgentID agentID;
  Set loadedClassesSet = new TreeSet();

  public AgentClassLoader() {}

  public AgentClassLoader( Environment env, String agentClass, AgentID agentID )
  {
    this.env = env;
    this.agentID = agentID;

    // Metto anche l'ID cos ho un CodeSource diverso per ogni classLoader
    // Portei fornire permessi specifici per un agente, dato il suo ID
    codeSource = new CodeSource( AgentToURL( agentClass, agentID ),
                                 new Certificate[0] );
  }

  public static URL AgentToURL( String AgentClass, AgentID agentID )
  {
    try
    {
      return new URL( "http://" + agentID.place.domain +
                            "/" + agentID.place.place +
                            "/" + AgentClass +
                            "/" + agentID.ID );
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
    return null;
  }

  protected Class findClass(final String className) throws ClassNotFoundException
  {
    try
    {
      return (Class)AccessController.doPrivileged(
        new PrivilegedExceptionAction()
          {
            public Object run() throws Exception
            {
              return myFindClass( className );
            }
          });
    }
    catch( PrivilegedActionException e )
    {
      throw new ClassNotFoundException( "AgentClassManager.findClass: Exception on Class " + className,
                                        e.getException() );
    }
  }

  private Class myFindClass( String className) throws Exception
  {
    Class theClass = null;
    /*
    env.err.println();
    env.err.println( "FindClass " + className );
    env.err.println();
    */

    // Attenzione: bruttino: il primo che finisce esce!
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // Stabilisco che la classe si trovi nella home dell'agente

    if( agentID.getHome().equals( env.placeID ) )
    {
      try // Carico dalla directory agents
      {
        byte[] classData = env.agentManager.agentClassManager.loadClassFile( className );
        theClass = defineClass( className, classData, 0, classData.length, codeSource );
      }
      catch( Exception f ) // Carico dalla directory cache
      {
        byte[] classData = env.agentManager.cacheClassManager.loadClassFile( className );
        theClass = defineClass( className, classData, 0, classData.length, codeSource );
      }
    }
    else
    {
      try // Carico dalla directory cache
      {
        byte[] classData = env.agentManager.cacheClassManager.loadClassFile( className );
        theClass = defineClass( className, classData, 0, classData.length, codeSource );
      }
      catch( Exception f ) // Carico dal place di origine.
      {
        theClass = findFromRemote( className );
      }
    }

    loadedClassesSet.add( className );
    return theClass;
  }

  public Class findFromRemote( final String className ) throws ClassNotFoundException
  {
    WaitAndTimeout syncho = new WaitAndTimeout( 60 * 1000, "class " + className, env.out ); // 60 secondi di timeout

    int synchroIndex = env.agentManager.indexStore.put( syncho );
    int classDataIndex = env.agentManager.indexStore.put( new Object() ); // Semplicemente: faccio posto

    byte[] classData = null;

    try
    {
      env.networkManager.startPermanentConnection( agentID.getHome() );
      if( !env.networkManager.sendCommand(
              agentID.getHome(),
              new ClassRequestCommand( className, env.placeID, classDataIndex, synchroIndex )))
            throw new ClassNotFoundException( "AgentClassManager.findClass: can't send ClassRequestCommand." );

      //env.err.println( Thread.currentThread().toString() + " is going to WAIT on index " + synchroIndex );

      if( syncho.Wait() == WaitAndTimeout.TIMEOUT )
      {
        //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        env.err.println( toString() + "PROBLEMA DI CLASSLOADING. Aspetto 20 secondi prima di lanciare l'eccezione!" );

        synchronized( this )
        {
          try
          {
            wait( 20 * 1000 );
          }
          catch( InterruptedException e )
          {
            e.printStackTrace( env.err );
          }
          env.err.println( toString() + "Ora vado." );
        }

        throw new ClassNotFoundException( "AgentClassManager.findClass: Receive class TIMEOUT EXPIRED." );
      }

      classData = (byte[])env.agentManager.indexStore.get( classDataIndex );
    }
    finally // Faccio le pulizie!
    {
      env.agentManager.indexStore.remove( synchroIndex );
      env.agentManager.indexStore.remove( classDataIndex );
      env.networkManager.stopPermanentConnection( agentID.getHome() );
    }

    if( classData != null )
    {
      final byte[] finalClassData = classData; // Un modo semplice per passare un parametro.

      // Salvo nella cache in background!!!
      Thread saver = new Thread( "[Cache Saver: " + className + "]")
        {
          public void run()
          {
            yield(); // Lo faccio dopo!
            try
            {
              env.agentManager.cacheClassManager.saveClassFile( className, finalClassData );
            }
            catch( Exception e )
            {
              e.printStackTrace();
            }
          }
        };

      saver.setPriority( Thread.MIN_PRIORITY );
      saver.start();
    }

    return defineClass( className, classData, 0, classData.length, codeSource );
  }

  public Set getLoadedClassesSet()
  {
    return loadedClassesSet;
  }

  public String toString()
  {
    return "[AgentClassLoader " + agentID + " <-> " + codeSource + "]";
  }

  /*
  public void finalize()
  {
    env.err.println( "*** FINALIZE " + this + " ***" );
  }*/
}