/**
 *  Inizio del programma (di interfaccia utente).
 *  Si "appoggia" a {@link SOMA.Main} per la creazione del men.
 *  Quindi NON crea un explorer thread (perci non carica neppure i file di script)
 *  ma apre la finestra "Inizio" della GUI.
 *  Vedi {@link SOMA.gui.Inizio}.
 *
 *     @author     Luigi Antenucci ( aggiunte di Angelo )
 *     @version    5.55
 *     @language   jdk 1.2.2
 */

package SOMA;

import SOMA.gui.Inizio;
import SOMA.gui.FinOpzioni;
import SOMA.explorer.ExplorerThread;
import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.ExplorerItem;

import java.io.PrintStream;
import java.util.Collection;


public class MainGui {

  static public void main (String[] args) {

    System.out.println ("*** S.O.M.A. ***  by Faculty of Computer Science Engineering");
    System.out.println ("                  of the University of Bologna (Italy)");
    System.out.println ("use << MainGui -? >> for command line syntax");

    // COSTRUZIONE DEL MENU'
    // DirExplorerItem menuScifoso = Main.buildMenu();  // Lo richiedo alla classe "Main"

    // DirExplorerItem menuScifoso = SOMA.security.auth.MainSecurity.buildMenu();

    DirExplorerItem menuScifoso = SOMA.security.MainSecurityAng.buildMenu(); // aggiunta di Angelo

    boolean bootGigiGui = true;
    boolean bootOnlyCfg = false;

    String param;
    char primo;
    for (int i=0; i<args.length; i++) {
      primo = args[i].charAt(0);
      if (primo == '/')
        param = "-" + args[i].substring(1);
      else
        param = args[i];

      if (param.equals("-?")) {
        System.out.println ("\nCommand line options: (starting with '-' or '/')");
        System.out.println ("  -?     shows this help lines");
        System.out.println ("  -menu  starts without GUI (directly in command-menu mode)");
        System.out.println ("  -cfg   opens the window with the start-up & configuration options");
        System.out.println ("\n You should run the program with a command like this:");
        System.out.println ("  << java -Djava.security.policy=SOMA.policy SOMA.MainGui >> \n");
        System.exit(0);
      }

      if (param.equals("-menu")) {
        bootGigiGui = false;
      }
      else
        if (param.equals("-cfg")) {
          bootOnlyCfg = true;
        }
        else {
          System.out.println ("UNKNOWN PARAMETER '"+param+"' IN POSITION "+i);
          System.exit(0);
        }

    } //for

    // QUESTO SERVE PERCHE' VIENE FATTO NELLA "main" di "Main" e non nella buildMenu!
    menuScifoso.addItem( "end",
      new ExplorerItem ("Terminates the Java Virtual Machine!") {
        public Object Execute (Collection Parameters, PrintStream out) {
          if (Parameters.size() == 0)
            System.exit(0);
          else
            out.println("NO PARAMETERS to exit the system!");
          return null;
        }
      });

    if (bootGigiGui) {

      if (bootOnlyCfg) {

        FinOpzioni fin = new FinOpzioni ();

      }
      else {         // ECCO IL MIO GRANDIOSO MENU'

        // LANCIA INTERFACCIA GRAFICA (di Luigi Antenucci)
        Inizio inizioVero = new Inizio (menuScifoso);

      }
    }
    else {           // ED ECCO QUELLO SCHIFOSO MENU'

      ExplorerThread Explorer = new ExplorerThread (menuScifoso);
      Explorer.addExit();
      Explorer.start();

    }
  } //main

} //MainGui