/*
 * Decompiled with CFR 0.152.
 */
package res;

import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Date;
import res.MainThread;
import res.NetworkInfo;
import res.ProcessInfo;

public class ProcessMonitor {
    static {
        try {
            System.loadLibrary("ps");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("Unable to find " + System.mapLibraryName("ps") + " in path " + System.getProperty("java.library.path"));
        }
    }

    private NetworkInfo getNetworkInfo() {
        NetworkInfo networkInfo = new NetworkInfo();
        networkInfo.interval = new Date().getTime();
        try {
            if (System.getProperty("os.name").startsWith("Win")) {
                Process process = Runtime.getRuntime().exec("netstat -s");
                StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(process.getInputStream()));
                int n = 0;
                while (streamTokenizer.ttype != -1) {
                    if (streamTokenizer.ttype == -2) {
                        switch (n++) {
                            case 0: {
                                networkInfo.ip_pack_in = (int)streamTokenizer.nval;
                                break;
                            }
                            case 6: {
                                networkInfo.ip_pack_in_err = networkInfo.ip_pack_in - (int)streamTokenizer.nval;
                                break;
                            }
                            case 7: {
                                networkInfo.ip_pack_out = (int)streamTokenizer.nval;
                                break;
                            }
                            case 47: {
                                networkInfo.tcp_conn = (int)streamTokenizer.nval;
                                break;
                            }
                            case 48: {
                                networkInfo.tcp_seg_in = (int)streamTokenizer.nval;
                                break;
                            }
                            case 49: {
                                networkInfo.tcp_seg_out = (int)streamTokenizer.nval;
                                break;
                            }
                            case 51: {
                                networkInfo.udp_pack_in = (int)streamTokenizer.nval;
                                break;
                            }
                            case 52: {
                                networkInfo.udp_pack_in_err = (int)streamTokenizer.nval;
                                break;
                            }
                            case 53: {
                                networkInfo.udp_pack_in_err += (int)streamTokenizer.nval;
                                break;
                            }
                            case 54: {
                                networkInfo.udp_pack_out = (int)streamTokenizer.nval;
                                break;
                            }
                        }
                    }
                    streamTokenizer.nextToken();
                }
            } else {
                Process process = Runtime.getRuntime().exec("netstat -s");
                StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(process.getInputStream()));
                int n = 0;
                while (streamTokenizer.ttype != -1) {
                    if (streamTokenizer.ttype == -2) {
                        switch (n++) {
                            case 55: {
                                networkInfo.ip_pack_in = (int)streamTokenizer.nval;
                                break;
                            }
                            case 56: {
                                networkInfo.ip_pack_in_err = (int)streamTokenizer.nval;
                                break;
                            }
                            case 57: 
                            case 58: {
                                networkInfo.ip_pack_in_err += (int)streamTokenizer.nval;
                                break;
                            }
                            case 64: {
                                networkInfo.ip_pack_out = (int)streamTokenizer.nval;
                                break;
                            }
                            case 11: {
                                networkInfo.tcp_conn = (int)streamTokenizer.nval;
                                break;
                            }
                            case 25: {
                                networkInfo.tcp_seg_in = (int)streamTokenizer.nval;
                                break;
                            }
                            case 12: {
                                networkInfo.tcp_seg_out = (int)streamTokenizer.nval;
                                break;
                            }
                            case 0: {
                                networkInfo.udp_pack_in = (int)streamTokenizer.nval;
                                break;
                            }
                            case 1: {
                                networkInfo.udp_pack_in_err = (int)streamTokenizer.nval;
                                break;
                            }
                            case 2: {
                                networkInfo.udp_pack_out = (int)streamTokenizer.nval;
                                break;
                            }
                        }
                    }
                    streamTokenizer.nextToken();
                }
            }
        }
        catch (Exception exception) {
            networkInfo.ip_pack_in = 0;
            networkInfo.ip_pack_in_err = 0;
            networkInfo.ip_pack_out = 0;
            networkInfo.tcp_conn = 0;
            networkInfo.tcp_seg_in = 0;
            networkInfo.tcp_seg_out = 0;
            networkInfo.udp_pack_in = 0;
            networkInfo.udp_pack_in_err = 0;
            networkInfo.udp_pack_out = 0;
        }
        return networkInfo;
    }

    public NetworkInfo getNetworkInfo(long l) {
        NetworkInfo networkInfo = this.getNetworkInfo();
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {}
        NetworkInfo networkInfo2 = this.getNetworkInfo();
        networkInfo2.udp_pack_in -= networkInfo.udp_pack_in;
        networkInfo2.udp_pack_out -= networkInfo.udp_pack_out;
        networkInfo2.udp_pack_in_err -= networkInfo.udp_pack_in_err;
        networkInfo2.tcp_conn -= networkInfo.tcp_conn;
        networkInfo2.tcp_seg_in -= networkInfo.tcp_seg_in;
        networkInfo2.tcp_seg_out -= networkInfo.tcp_seg_out;
        networkInfo2.ip_pack_in -= networkInfo.ip_pack_in;
        networkInfo2.ip_pack_out -= networkInfo.ip_pack_out;
        networkInfo2.ip_pack_in_err -= networkInfo.ip_pack_in_err;
        networkInfo2.interval -= networkInfo.interval;
        return networkInfo2;
    }

    public String getOs() {
        return String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version");
    }

    public native int getPid();

    public native ProcessInfo getProcessInfo(int var1, long var2) throws Exception;

    public native ProcessInfo[] getProcessInfo(long var1);

    public int getVersion() {
        return 1;
    }

    public static void run(String string, String[] stringArray) throws Exception {
        MainThread mainThread = new MainThread(string, stringArray);
        mainThread.start();
    }

    public String toString() {
        return "ProcessMonitor";
    }
}

