/*
 * Decompiled with CFR 0.152.
 */
package SOMA.network.connection;

import SOMA.Environment;
import SOMA.network.connection.Command;
import SOMA.network.connection.ConnectionException;
import SOMA.network.connection.Daemon;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class Connection
implements Daemon,
Runnable {
    Thread myDaemon = null;
    Socket mySocket = null;
    ObjectInputStream myObjectInputStream = null;
    ObjectOutputStream myObjectOutputStream = null;
    Object status = Daemon.OFF;
    String ErrorDescription = "";
    Environment env = null;

    protected Connection() {
    }

    public Connection(Socket socket, Environment environment) {
        this.mySocket = socket;
        this.env = environment;
        try {
            this.myObjectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            this.myObjectInputStream = new ObjectInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            this.status = Daemon.ERROR;
            this.ErrorDescription = iOException.toString();
        }
    }

    public InputStream getIn() {
        return this.myObjectInputStream;
    }

    public OutputStream getOut() {
        return this.myObjectOutputStream;
    }

    public Object getStatus() {
        return this.status;
    }

    public void run() {
        while (this.status == Daemon.ON) {
            try {
                Command command = (Command)this.myObjectInputStream.readObject();
                command.start(this, this.env);
            }
            catch (EOFException eOFException) {
                this.status = Daemon.OFF;
            }
            catch (SocketException socketException) {
                this.status = Daemon.OFF;
            }
            catch (IOException iOException) {
                this.status = Daemon.ERROR;
                this.ErrorDescription = iOException.toString();
                iOException.printStackTrace(this.env.err);
            }
            catch (Exception exception) {
                exception.printStackTrace(this.env.err);
            }
        }
    }

    public void send(Command command) throws IOException, ConnectionException {
        if (this.status == Daemon.ERROR) {
            throw new ConnectionException("The connection status is ERROR");
        }
        this.myObjectOutputStream.writeObject(command);
        this.myObjectOutputStream.flush();
    }

    public synchronized void start() throws ConnectionException {
        if (this.status == Daemon.OFF) {
            this.myDaemon = this.env != null ? new Thread(this.env.threadGroup, this, this.toString()) : new Thread((Runnable)this, this.toString());
            this.status = Daemon.ON;
            this.myDaemon.setDaemon(true);
            try {
                this.myDaemon.setContextClassLoader(ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            throw new ConnectionException("Connection not OFF");
        }
        this.myDaemon.start();
    }

    public synchronized void stop() throws Exception {
        try {
            this.myObjectOutputStream.close();
            this.myObjectInputStream.close();
            this.mySocket.close();
            this.status = Daemon.OFF;
        }
        catch (Exception exception) {
            this.status = Daemon.ERROR;
            this.ErrorDescription = exception.toString();
            throw exception;
        }
    }

    public String toString() {
        return "[Connection with" + this.mySocket + " Status: " + this.status + (this.status == Daemon.ERROR ? " " + this.ErrorDescription : "") + "]";
    }
}

