/*
 * Decompiled with CFR 0.152.
 */
package SOMA.network;

import SOMA.Environment;
import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.ExplorerItem;
import SOMA.explorer.ObjectExplorerItem;
import SOMA.mobilePlace.MobileEnvironment;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.mobilePlace.MobilePlaceManager;
import SOMA.naming.NameException;
import SOMA.naming.PlaceID;
import SOMA.naming.domain.DomainInfo;
import SOMA.naming.place.PlaceInfo;
import SOMA.network.ConnectionCommand;
import SOMA.network.ConnectionStore;
import SOMA.network.StopConnectionCommand;
import SOMA.network.TransportCommand;
import SOMA.network.connection.Command;
import SOMA.network.connection.Connection;
import SOMA.network.connection.ConnectionExplorerItem;
import SOMA.network.connection.ConnectionServer;
import SOMA.network.connection.Daemon;
import SOMA.network.connection.DaemonExplorerItem;
import SOMA.network.connection.ExplorableConnectionFactory;
import SOMA.network.connection.SelfConnection;
import SOMA.network.connection.SendMessageCommand;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class NetworkManager {
    Environment env;
    ConnectionServer connectionServer = null;
    private Hashtable permanentConnections = new Hashtable();
    public PlaceInfo placeInfo;
    DirExplorerItem networkManagerDir;
    DirExplorerItem connectionsDir;
    int connectionCount = 1;
    public ConnectionStore connectionStore = new ConnectionStore();

    public NetworkManager(Environment environment, int n) throws IOException, ConnectionServer.ConnectionServerException, NameException {
        this.env = environment;
        this.placeInfo = environment.placeID.isDomain() ? new DomainInfo(environment.placeID, InetAddress.getLocalHost(), n) : new PlaceInfo(environment.placeID, InetAddress.getLocalHost(), n);
        this.networkManagerDir = new DirExplorerItem("netManager");
        environment.dir.addItem(this.networkManagerDir);
        this.networkManagerDir.addItem("placeInfo", new ObjectExplorerItem(this.placeInfo));
        this.connectionsDir = new DirExplorerItem("connections");
        this.networkManagerDir.addItem(this.connectionsDir);
        SelfConnection selfConnection = new SelfConnection(environment);
        this.connectionStore.putConnection(environment.placeID, selfConnection);
        this.connectionsDir.addItem("selfConnection", new ConnectionExplorerItem(selfConnection));
        this.connectionServer = new ConnectionServer(n, 100, new ExplorableConnectionFactory(environment, this.connectionsDir, "servConn"));
        this.networkManagerDir.addItem("server", new DaemonExplorerItem(this.connectionServer));
        this.connectionServer.start();
        if (environment.placeID.isDomain()) {
            environment.domainNameService.putDomain((DomainInfo)this.placeInfo);
        }
        environment.placeNameService.putPlace(this.placeInfo);
        this.networkManagerDir.addItem("connList", new ExplorerItem("List of connections"){

            public Object Execute(Collection collection, PrintStream printStream) {
                NetworkManager.this.connectionStore.printConnections(printStream);
                return null;
            }
        });
        this.networkManagerDir.addItem("send", new ExplorerItem("<PlaceID> <Message>"){

            public Object Execute(Collection collection, PrintStream printStream) {
                if (collection.size() > 1) {
                    Iterator iterator = collection.iterator();
                    PlaceID placeID = null;
                    try {
                        placeID = MobilePlaceID.parsePlaceID((String)iterator.next());
                    }
                    catch (NameException nameException) {
                        printStream.println(nameException);
                        return nameException;
                    }
                    SendMessageCommand sendMessageCommand = new SendMessageCommand((String)iterator.next());
                    printStream.println("Sending command " + sendMessageCommand + " to " + placeID);
                    if (NetworkManager.this.sendCommand(placeID, sendMessageCommand)) {
                        printStream.println("Message " + sendMessageCommand + " sent!");
                        return new Boolean(true);
                    }
                    printStream.println("ERROR: Message " + sendMessageCommand + " NOT SENT!");
                    return new Boolean(true);
                }
                printStream.println("incorrect number of parameters");
                return null;
            }
        });
        this.networkManagerDir.addItem("perm", new PermanentConnectionsExplorerItem());
    }

    static /* synthetic */ Hashtable access$0(NetworkManager networkManager) {
        return networkManager.permanentConnections;
    }

    public int isPermanentConnection(PlaceID placeID) {
        int n = 0;
        Integer n2 = (Integer)this.permanentConnections.get(placeID.getDomainID());
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public boolean sendCommand(PlaceID placeID, Command command) {
        boolean bl = false;
        PlaceID placeID2 = this.env.placeID instanceof MobilePlaceID ? ((MobileEnvironment)this.env).currentDomainID : this.env.placeID.getDomainID();
        if (placeID instanceof MobilePlaceID) {
            bl = this.sendCommandToMobilePlace((MobilePlaceID)placeID, command);
        } else if (placeID2.sameDomain(placeID)) {
            bl = this.sendCommandToPlace(placeID, command);
            if (!bl) {
                bl = this.sendCommandToMobilePlace(new MobilePlaceID(placeID), command);
            }
        } else if (this.env.placeNameService.getPlace(placeID) != null) {
            bl = this.sendCommandToMobilePlace(new MobilePlaceID(placeID), command);
        } else if (this.env.placeID.isDomain()) {
            Command command2 = placeID.isDomain() ? command : new TransportCommand(placeID, command);
            bl = this.sendCommandToDomain(placeID.getDomainID(), command2);
        } else {
            bl = this.sendCommandToPlace(placeID2, new TransportCommand(placeID, command));
        }
        return bl;
    }

    public boolean sendCommand(InetAddress inetAddress, int n, Command command) {
        boolean bl = true;
        try {
            Connection connection = new Connection(new Socket(inetAddress, n), this.env);
            this.connectionsDir.addItem("clientConn" + this.connectionCount++, new ConnectionExplorerItem(connection));
            connection.start();
            connection.send(command);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.env.err);
            bl = false;
        }
        return bl;
    }

    private boolean sendCommandToDomain(PlaceID placeID, Command command) {
        boolean bl;
        block7: {
            DomainInfo domainInfo;
            bl = false;
            Connection connection = this.connectionStore.getConnection(placeID);
            boolean bl2 = this.isPermanentConnection(placeID) > 0;
            boolean bl3 = false;
            if ((connection == null || connection.getStatus() != Daemon.ON) && (domainInfo = this.env.domainNameService.getDomain(placeID)) != null) {
                try {
                    connection = new Connection(new Socket(domainInfo.host, domainInfo.port), this.env);
                    this.connectionsDir.addItem(String.valueOf(placeID.domain) + this.connectionCount++, new ConnectionExplorerItem(connection));
                    if (bl2) {
                        this.connectionStore.putConnection(placeID, connection);
                        connection.start();
                        connection.send(new ConnectionCommand(this.env.placeID));
                    }
                    bl3 = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace(this.env.err);
                    bl = false;
                }
            }
            if (connection == null) break block7;
            try {
                connection.send(command);
                bl = true;
                if (!bl2 && bl3) {
                    connection.stop();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.env.err);
                bl = false;
            }
        }
        return bl;
    }

    private boolean sendCommandToMobilePlace(MobilePlaceID mobilePlaceID, Command command) {
        boolean bl = this.sendCommandToPlace(mobilePlaceID, command);
        if (!bl) {
            if (!mobilePlaceID.getHome().equals(this.env.placeID)) {
                bl = this.sendCommand(mobilePlaceID.getHome(), new TransportCommand(mobilePlaceID, command));
            } else {
                PlaceID placeID = this.env.mobilePlaceManager.getPosition(mobilePlaceID);
                if (placeID != null && !placeID.equals(MobilePlaceManager.DISCONNECTED) && !placeID.equals(this.env.placeID)) {
                    bl = this.sendCommand(placeID, new TransportCommand(mobilePlaceID, command));
                }
            }
        }
        return bl;
    }

    private boolean sendCommandToPlace(PlaceID placeID, Command command) {
        boolean bl;
        block5: {
            PlaceInfo placeInfo;
            bl = false;
            Connection connection = this.connectionStore.getConnection(placeID);
            if ((connection == null || connection.getStatus() != Daemon.ON) && (placeInfo = this.env.placeNameService.getPlace(placeID)) != null) {
                try {
                    connection = new Connection(new Socket(placeInfo.host, placeInfo.port), this.env);
                    this.connectionStore.putConnection(placeID, connection);
                    this.connectionsDir.addItem(String.valueOf(placeID.place) + this.connectionCount++, new ConnectionExplorerItem(connection));
                    connection.start();
                    connection.send(new ConnectionCommand(this.env.placeID));
                }
                catch (Exception exception) {
                    exception.printStackTrace(this.env.err);
                    bl = false;
                }
            }
            if (connection == null || connection.getStatus() != Daemon.ON) break block5;
            try {
                connection.send(command);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace(this.env.err);
                bl = false;
            }
        }
        return bl;
    }

    public int startPermanentConnection(PlaceID placeID) {
        int n = 0;
        if (this.env.placeID.isDomain() && !this.env.placeID.sameDomain(placeID)) {
            PlaceID placeID2 = placeID.getDomainID();
            Integer n2 = (Integer)this.permanentConnections.get(placeID2);
            n = n2 != null ? n2 + 1 : 1;
            this.permanentConnections.put(placeID2, new Integer(n));
        }
        return n;
    }

    public int stopPermanentConnection(PlaceID placeID) {
        PlaceID placeID2 = placeID.getDomainID();
        int n = this.isPermanentConnection(placeID2);
        if (n > 1) {
            this.permanentConnections.put(placeID2, new Integer(--n));
        } else if (this.env.placeID.isDomain() && !this.env.placeID.sameDomain(placeID)) {
            Connection connection;
            if (n == 1) {
                --n;
                this.permanentConnections.remove(placeID2);
            }
            if ((connection = this.connectionStore.getConnection(placeID2)) != null) {
                if (connection.getStatus() == Daemon.ON) {
                    try {
                        connection.send(new StopConnectionCommand(this.env.placeID));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(this.env.err);
                    }
                } else {
                    this.connectionStore.removeConnection(placeID2);
                }
            }
        }
        return n;
    }

    public String toString() {
        return "[netManager]";
    }

    public class PermanentConnectionsExplorerItem
    extends ExplorerItem {
        public PermanentConnectionsExplorerItem() {
            super("[\"placeID\" [start | stop]]");
        }

        /*
         * Unable to fully structure code
         */
        public Object Execute(Collection var1_1, PrintStream var2_2) {
            block8: {
                block7: {
                    if (var1_1.size() != 0) break block7;
                    var2_2.println("List of domain permanent connections:");
                    var2_2.println();
                    var3_3 = NetworkManager.access$0(NetworkManager.this).entrySet().iterator();
                    var4_5 = 1;
                    while (var3_3.hasNext()) {
                        var5_7 = var3_3.next();
                        var2_2.println("  " + var4_5 + ") " + var5_7.getKey() + " --> " + var5_7.getValue());
                        ++var4_5;
                    }
                    break block8;
                }
                var3_4 = var1_1.iterator();
                var4_6 = null;
                try {
                    var4_6 = new PlaceID((String)var3_4.next());
                }
                catch (NameException var5_8) {
                    var2_2.println("Invalid place ID: " + var5_8);
                    return var5_8;
                }
                var5_9 = 0;
                if (!var3_4.hasNext()) ** GOTO lbl32
                var6_10 = (String)var3_4.next();
                if ("start".equals(var6_10)) {
                    var5_9 = NetworkManager.this.startPermanentConnection(var4_6);
                } else if ("stop".equals(var6_10)) {
                    var5_9 = NetworkManager.this.stopPermanentConnection(var4_6);
                } else {
                    var2_2.println("Unknown operation: " + var6_10);
                    return null;
lbl32:
                    // 1 sources

                    var5_9 = NetworkManager.this.isPermanentConnection(var4_6);
                }
                var2_2.println("Number of pocesses using connection to " + var4_6 + ": " + var5_9);
                return new Integer(var5_9);
            }
            var2_2.println();
            return null;
        }
    }
}

