/*
 * Decompiled with CFR 0.152.
 */
package SOMA.network;

import SOMA.naming.PlaceID;
import SOMA.network.connection.Connection;
import SOMA.network.connection.Daemon;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ConnectionStore {
    private Hashtable connectionsTable = new Hashtable();

    public void closeAllConnections() {
        Iterator iterator = this.connectionsTable.entrySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            iterator.remove();
            try {
                ((Connection)entry.getValue()).stop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.removeConnection((PlaceID)entry.getKey());
            ++n;
        }
    }

    public Connection getConnection(PlaceID placeID) {
        return (Connection)this.connectionsTable.get(placeID);
    }

    public void printConnections(PrintStream printStream) {
        Iterator iterator = this.connectionsTable.entrySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            printStream.println("  " + n + ") " + entry.getKey() + " --> " + entry.getValue());
            ++n;
        }
    }

    public Connection putConnection(PlaceID placeID, Connection connection) {
        Connection connection2;
        block2: {
            connection2 = this.connectionsTable.put(placeID, connection);
            if (connection2 == null || connection2.getStatus() != Daemon.ON) break block2;
            System.err.println("NetworkManager.putConnection: ATTENZIONE: sto sostituendo una connessione attiva:");
            System.err.println("  VECCHIA " + connection2);
            System.err.println("  NUOVA " + connection);
            try {
                connection2.stop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return connection2;
    }

    public Connection removeConnection(PlaceID placeID) {
        Connection connection;
        block2: {
            connection = (Connection)this.connectionsTable.remove(placeID);
            if (connection == null || connection.getStatus() != Daemon.ON) break block2;
            System.err.println("NetworkManager.removeConnection: ATTENZIONE: sto cancellando una connessione attiva:");
            System.err.println("  " + connection);
            try {
                connection.stop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return connection;
    }
}

