/*
 * Decompiled with CFR 0.152.
 */
package SOMA.naming.place;

import SOMA.explorer.ExplorerItem;
import SOMA.naming.PlaceID;
import SOMA.naming.place.PlaceInfo;
import SOMA.naming.place.PlaceNameService;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PNSExplorerItem
extends ExplorerItem {
    PlaceNameService pns;

    public PNSExplorerItem(PlaceNameService placeNameService) {
        this.pns = placeNameService;
        this.Syntax = "{list | put <place> <host> <port> | del <place> | register <host> <port> | refresh {<host> <port>} }";
    }

    public Object Execute(Collection collection, PrintStream printStream) {
        try {
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) {
                return this.Help();
            }
            String string = (String)iterator.next();
            if (string.equals("list")) {
                this.pns.listPlaces(printStream);
                return this.pns.places;
            }
            if (string.equals("put")) {
                String string2 = (String)iterator.next();
                String string3 = (String)iterator.next();
                String string4 = (String)iterator.next();
                try {
                    int n = Integer.parseInt(string4);
                    PlaceInfo placeInfo = new PlaceInfo(new PlaceID(string2, ""), InetAddress.getByName(string3), n);
                    PlaceInfo placeInfo2 = this.pns.putPlace(placeInfo);
                    printStream.println("  Old Place: " + placeInfo2);
                    printStream.println("  New Place:" + placeInfo);
                    return placeInfo2;
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                    return null;
                }
            }
            if (string.equals("del")) {
                try {
                    PlaceID placeID = new PlaceID((String)iterator.next());
                    PlaceInfo placeInfo = this.pns.removePlace(placeID);
                    printStream.println("  Place " + placeInfo + " REMOVED");
                    return placeInfo;
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                    return null;
                }
            }
            if (string.equals("register")) {
                String string5 = (String)iterator.next();
                String string6 = (String)iterator.next();
                try {
                    if (this.pns.register(InetAddress.getByName(string5), Integer.parseInt(string6))) {
                        printStream.println("  Registration COMPLETED!");
                    } else {
                        printStream.println("  Registration FAILED!");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                }
                return null;
            }
            if (string.equals("refresh")) {
                if (iterator.hasNext()) {
                    String string7 = (String)iterator.next();
                    String string8 = (String)iterator.next();
                    try {
                        if (this.pns.refresh(InetAddress.getByName(string7), Integer.parseInt(string8))) {
                            printStream.println("  Refresh REQUESTED");
                        }
                        printStream.println("  Refresh FAILED!");
                    }
                    catch (UnknownHostException unknownHostException) {
                        unknownHostException.printStackTrace(printStream);
                        return null;
                    }
                } else if (this.pns.refresh()) {
                    printStream.println("  Refresh REQUESTED");
                } else {
                    printStream.println("  Refresh FAILED!");
                }
                return null;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            printStream.println("Wrong number of parameters");
        }
        return null;
    }
}

