/*
 * Decompiled with CFR 0.152.
 */
package SOMA.naming.domain;

import SOMA.Environment;
import SOMA.naming.PlaceID;
import SOMA.network.connection.Command;
import java.util.Hashtable;

public class DomainRefreshCommand
extends Command {
    PlaceID fatherDomainID;
    Hashtable domains;
    boolean closeConnection;

    public DomainRefreshCommand(Environment environment) {
        this(environment, false);
    }

    public DomainRefreshCommand(Environment environment, boolean bl) {
        this.fatherDomainID = environment.placeID;
        this.domains = environment.domainNameService.domains;
        this.closeConnection = bl;
        System.out.println(String.valueOf(this.toString()) + " (" + this.domains.size() + " domains) created.");
    }

    public void run() {
        this.env.domainNameService.fatherDNS = this.fatherDomainID;
        this.env.domainNameService.domains = this.domains;
        this.env.domainNameService.sendToChildrenDomains(new DomainRefreshCommand(this.env));
        if (this.closeConnection) {
            try {
                this.ReturnConnection.stop();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.env.err);
            }
        }
        this.env.out.println(String.valueOf(this.toString()) + " completed (" + this.domains.size() + " domains) !!!");
    }

    public String toString() {
        return "[RefreshCommand from " + this.fatherDomainID + " disconnect: " + this.closeConnection + "]";
    }

    public static class Request
    extends Command {
        boolean closeConnection = false;

        public Request() {
        }

        public Request(boolean bl) {
            this.closeConnection = bl;
        }

        public void run() {
            this.Return(new DomainRefreshCommand(this.env, this.closeConnection));
        }
    }
}

