/*
 * Decompiled with CFR 0.152.
 */
package SOMA.naming.domain;

import SOMA.explorer.ExplorerItem;
import SOMA.naming.PlaceID;
import SOMA.naming.domain.DomainInfo;
import SOMA.naming.domain.DomainNameService;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DNSExplorerItem
extends ExplorerItem {
    DomainNameService dns;

    public DNSExplorerItem(DomainNameService domainNameService) {
        this.dns = domainNameService;
        this.Syntax = "{list | put <domain> <host> <port> | del <domain> | register <host> <port> | refresh {<host> <port>} }";
    }

    public Object Execute(Collection collection, PrintStream printStream) {
        try {
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) {
                return this.Help();
            }
            String string = (String)iterator.next();
            if (string.equals("list")) {
                this.dns.listDomains(printStream);
                return this.dns.domains;
            }
            if (string.equals("put")) {
                String string2 = (String)iterator.next();
                String string3 = (String)iterator.next();
                String string4 = (String)iterator.next();
                try {
                    int n = Integer.parseInt(string4);
                    DomainInfo domainInfo = new DomainInfo(new PlaceID(string2, ""), InetAddress.getByName(string3), n);
                    DomainInfo domainInfo2 = this.dns.putDomain(domainInfo);
                    printStream.println("  Old Domain: " + domainInfo2);
                    printStream.println("  New Domain:" + domainInfo);
                    return domainInfo2;
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                    return null;
                }
            }
            if (string.equals("del")) {
                try {
                    PlaceID placeID = new PlaceID((String)iterator.next());
                    DomainInfo domainInfo = this.dns.removeDomain(placeID);
                    printStream.println("  Domain " + domainInfo + " REMOVED");
                    return domainInfo;
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                    return null;
                }
            }
            if (string.equals("register")) {
                String string5 = (String)iterator.next();
                String string6 = (String)iterator.next();
                try {
                    if (this.dns.register(InetAddress.getByName(string5), Integer.parseInt(string6))) {
                        printStream.println("  Registration COMPLETED!");
                    } else {
                        printStream.println("  Registration FAILED!");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                }
                return null;
            }
            if (string.equals("refresh")) {
                if (iterator.hasNext()) {
                    String string7 = (String)iterator.next();
                    String string8 = (String)iterator.next();
                    try {
                        if (this.dns.refresh(InetAddress.getByName(string7), Integer.parseInt(string8))) {
                            printStream.println("  Refresh REQUESTED");
                        }
                        printStream.println("  Refresh FAILED!");
                    }
                    catch (UnknownHostException unknownHostException) {
                        unknownHostException.printStackTrace(printStream);
                        return null;
                    }
                } else if (this.dns.refresh()) {
                    printStream.println("  Refresh REQUESTED");
                } else {
                    printStream.println("  Refresh FAILED!");
                }
                return null;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            printStream.println("Wrong number of parameters");
        }
        return null;
    }
}

