/*
 * Decompiled with CFR 0.152.
 */
package SOMA.mobilePlace;

import SOMA.Environment;
import SOMA.agent.AgentWorker;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.mobilePlace.MobilePlaceManagerExplorerItem;
import SOMA.naming.AgentID;
import SOMA.naming.PlaceID;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MobilePlaceManager
implements Serializable {
    transient Environment env;
    Hashtable mobilePlacePositions = new Hashtable();
    Hashtable waitingAgents = new Hashtable();
    public static final PlaceID DISCONNECTED = new PlaceID("", ""){

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return "DISCONNECTED";
        }
    };

    public MobilePlaceManager(Environment environment) {
        this.env = environment;
        environment.dir.addItem("mpm", new MobilePlaceManagerExplorerItem(this));
    }

    public void addWaitingAgent(AgentID agentID, PlaceID placeID) {
        Set<AgentID> set = (Set<AgentID>)this.waitingAgents.get(placeID);
        if (set == null) {
            set = Collections.synchronizedSet(new HashSet());
            this.waitingAgents.put(placeID, set);
        }
        set.add(agentID);
        this.env.out.println("MobilePlaceManager: Agent " + agentID + " is waiting for Mobile Place " + placeID);
    }

    public boolean checkWaitCondition(PlaceID placeID) {
        return placeID instanceof MobilePlaceID && this.env.placeID.equals(placeID.getHome()) && this.getPosition(placeID) == DISCONNECTED;
    }

    public PlaceID getPosition(PlaceID placeID) {
        return (PlaceID)this.mobilePlacePositions.get(placeID);
    }

    public void printMobilePlacePositions(PrintStream printStream) {
        printStream.println("Mobile places positions: ");
        Iterator iterator = this.mobilePlacePositions.entrySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            printStream.println("  " + n + ") " + entry.getKey() + " --> " + entry.getValue());
            ++n;
        }
        printStream.println();
    }

    public void printStatus(PrintStream printStream) {
        this.printMobilePlacePositions(printStream);
        this.printWaitingAgents(printStream);
    }

    public void printWaitingAgents(PrintStream printStream) {
        printStream.println("List of agents waiting for Mobile Place connection:");
        Iterator iterator = this.waitingAgents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            printStream.println("  Place: " + entry.getKey() + " agentIDs:");
            Iterator iterator2 = ((Set)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                printStream.println("      " + iterator2.next());
            }
        }
        printStream.println();
    }

    public PlaceID putPosition(PlaceID placeID, PlaceID placeID2) {
        return this.mobilePlacePositions.put(placeID, placeID2);
    }

    public PlaceID removePosition(PlaceID placeID) {
        this.waitingAgents.remove(placeID);
        return (PlaceID)this.mobilePlacePositions.remove(placeID);
    }

    void sendWaitingAgents(PlaceID placeID) {
        Set set = (Set)this.waitingAgents.get(placeID);
        if (set == null) {
            this.env.out.println("sendWaitingAgents: no agent is waiting for:" + placeID);
        } else {
            this.env.out.println("SENDING AGENTS to: " + placeID);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AgentID agentID = (AgentID)iterator.next();
                iterator.remove();
                try {
                    AgentWorker agentWorker = this.env.agentManager.agentWorkerStore.getWorker(agentID);
                    agentWorker.go(placeID);
                }
                catch (Exception exception) {
                    this.env.out.println("Agent -->" + agentID + " ERROR: " + exception);
                }
            }
            this.env.out.println("  =================  DONE!!!");
        }
    }

    public void setEnv(Environment environment) {
        if (this.env == null) {
            this.env = environment;
        }
    }

    public String toString() {
        return "[mpm: " + this.mobilePlacePositions.size() + " mobilePlaces]";
    }
}

