/*
 * Decompiled with CFR 0.152.
 */
package SOMA.mobilePlace;

import SOMA.naming.NameException;
import SOMA.naming.PlaceID;

public class MobilePlaceID
extends PlaceID {
    public static final String PREFIX = "(M) ";

    public MobilePlaceID(PlaceID placeID) {
        this(placeID.domain, placeID.place);
    }

    public MobilePlaceID(String string) throws NameException {
        super(MobilePlaceID.removePrefix(string));
        if (this.isDomain()) {
            throw new RuntimeException("MobilePlaceID: (" + this.domain + ") Can't create a mobile default place!");
        }
    }

    public MobilePlaceID(String string, String string2) {
        super(string, string2);
        if (string2.equals("")) {
            throw new RuntimeException("MobilePlaceID: (" + string + ") Can't create a mobile default place!");
        }
    }

    public PlaceID getHome() {
        return this.getDomainID();
    }

    public static boolean isMobile(String string) {
        return string.startsWith(PREFIX);
    }

    public static PlaceID parsePlaceID(String string) throws NameException {
        if (MobilePlaceID.isMobile(string)) {
            return new MobilePlaceID(string);
        }
        return new PlaceID(string);
    }

    public static String removePrefix(String string) {
        if (MobilePlaceID.isMobile(string)) {
            return string.substring(PREFIX.length()).trim();
        }
        return string;
    }

    public String toString() {
        return PREFIX + this.domain + " " + this.place;
    }
}

