/*
 * Decompiled with CFR 0.152.
 */
package SOMA.mobilePlace;

import SOMA.Environment;
import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.ExplorerItem;
import SOMA.explorer.ObjectExplorerItem;
import SOMA.mobilePlace.MobilePlaceConnectionCommand;
import SOMA.mobilePlace.MobilePlaceDisconnectionCommand;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.mobilePlace.MobilePlaceManager;
import SOMA.mobilePlace.MobilePlaceNameService;
import SOMA.naming.PlaceID;
import SOMA.naming.domain.DNSExplorerItem;
import SOMA.naming.domain.DomainInfo;
import SOMA.naming.domain.DomainNameService;
import SOMA.naming.place.PNSExplorerItem;
import SOMA.naming.place.PlaceInfo;
import SOMA.utility.GetLocalHost;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.Collection;

public class MobileEnvironment
extends Environment {
    public PlaceID currentDomainID = MobilePlaceManager.DISCONNECTED;

    public MobileEnvironment(PlaceID placeID, DirExplorerItem dirExplorerItem, int n, InputStream inputStream, PrintStream printStream, PrintStream printStream2) throws Exception {
        super(placeID, dirExplorerItem, n, inputStream, printStream, printStream2);
        if (!(placeID instanceof MobilePlaceID)) {
            printStream.println("**** WARNING: Mobile Place " + this + " created with a non mobile PlaceID.");
        }
        dirExplorerItem.addItem("currentDomain", new ObjectExplorerItem(this.currentDomainID){

            public Object Execute(Collection collection, PrintStream printStream) {
                return MobileEnvironment.this.currentDomainID;
            }

            public String getSyntax() {
                return MobileEnvironment.this.currentDomainID.toString();
            }
        });
        dirExplorerItem.addItem("connect", new ExplorerItem("<DomainID>"){

            public Object Execute(Collection collection, PrintStream printStream) {
                PlaceID placeID = new PlaceID((String)collection.iterator().next(), "");
                printStream.println("Connecting to domain: " + placeID);
                MobileEnvironment.this.connect(placeID);
                return null;
            }
        });
        dirExplorerItem.addItem("disconnect", new ExplorerItem("disconnects mobile place from the current domain."){

            public Object Execute(Collection collection, PrintStream printStream) {
                MobileEnvironment.this.disconnect();
                return null;
            }
        });
    }

    public void connect(PlaceID placeID) {
        if (this.currentDomainID.equals(MobilePlaceManager.DISCONNECTED)) {
            try {
                this.networkManager.placeInfo = new PlaceInfo(this.placeID, GetLocalHost.getCurrentLocalHost(this.out), this.networkManager.placeInfo.port);
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace(this.out);
            }
            ((MobilePlaceNameService)this.placeNameService).clear();
            DomainInfo domainInfo = this.domainNameService.getDomain(placeID);
            if (domainInfo != null) {
                if (this.networkManager.sendCommand(domainInfo.host, domainInfo.port, new MobilePlaceConnectionCommand(this.networkManager.placeInfo))) {
                    this.out.println("MobilePlaceConnectionCommand sent!");
                } else {
                    this.out.println("ERROR: MobilePlaceConnectionCommand NOT sent!");
                }
            } else {
                this.out.println("I don't know domain: " + placeID);
            }
        } else {
            this.out.println("Mobile place ALREADY CONNECTED to " + this.currentDomainID);
        }
    }

    protected void createNameServices() {
        this.domainNameService = new DomainNameService(this);
        this.dir.addItem("dns", new DNSExplorerItem(this.domainNameService));
        this.placeNameService = new MobilePlaceNameService(this);
        this.dir.addItem("pns", new PNSExplorerItem(this.placeNameService));
    }

    public void disconnect() {
        if (!this.currentDomainID.equals(MobilePlaceManager.DISCONNECTED)) {
            this.networkManager.sendCommand(this.currentDomainID, new MobilePlaceDisconnectionCommand(this.networkManager.placeInfo.placeID));
            this.currentDomainID = MobilePlaceManager.DISCONNECTED;
            this.networkManager.connectionStore.closeAllConnections();
            ((MobilePlaceNameService)this.placeNameService).clear();
            this.out.println("Disconnection perforomed.");
        } else {
            this.out.println("Mobile place ALREADY DISCONNECTED!");
        }
    }

    public String toString() {
        return "[Mobile " + super.toString() + " --> " + this.currentDomainID + "]";
    }
}

