/*
 * Decompiled with CFR 0.152.
 */
package SOMA.explorer;

import SOMA.explorer.ExplorerItem;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DirExplorerItem
extends ExplorerItem {
    private final Hashtable Items = new Hashtable();
    private final List Index = Collections.synchronizedList(new ArrayList());
    String DirectoryName;
    public static final String UpperLevelDirectoryString = "..";
    public static final String RootDirectoryString = "/";
    static final int EndPosition = -1;

    public DirExplorerItem(String string) {
        this.DirectoryName = string;
        this.Syntax = "Directory";
        this.addItem(RootDirectoryString, new ExplorerItem("root directory"){

            public Object Execute(Collection collection, PrintStream printStream) {
                return DirExplorerItem.this.FindRootDirectory().Execute(collection, printStream);
            }
        });
        this.addItem("cd", new ChangeDirExplorerItem());
        this.addItem("help", new HelpExplorerItem());
    }

    public String BuildPath() {
        DirExplorerItem dirExplorerItem = (DirExplorerItem)this.Items.get(UpperLevelDirectoryString);
        if (dirExplorerItem == null) {
            return this.DirectoryName;
        }
        return String.valueOf(dirExplorerItem.BuildPath()) + RootDirectoryString + this.DirectoryName;
    }

    public Object Execute(String string) {
        return this.Execute(this.StringToParameters(string));
    }

    public Object Execute(String string, PrintStream printStream) {
        return this.Execute(this.StringToParameters(string), printStream);
    }

    public Object Execute(Collection collection, PrintStream printStream) {
        Iterator iterator = collection.iterator();
        Object object = null;
        if (iterator.hasNext()) {
            Object e = iterator.next();
            ExplorerItem explorerItem = (ExplorerItem)this.Items.get(e);
            if (explorerItem == null) {
                printStream.println("> Item " + e + " not found.");
            } else {
                iterator.remove();
                object = explorerItem.Execute(collection, printStream);
            }
        } else {
            printStream.println("> Listing:");
            this.PrintDirectory(printStream);
            object = this;
        }
        return object;
    }

    public DirExplorerItem FindDirectory(Collection collection, PrintStream printStream) {
        Iterator iterator = collection.iterator();
        DirExplorerItem dirExplorerItem = null;
        if (iterator.hasNext()) {
            Object e = iterator.next();
            ExplorerItem explorerItem = (ExplorerItem)this.Items.get(e);
            if (explorerItem instanceof DirExplorerItem) {
                DirExplorerItem dirExplorerItem2 = (DirExplorerItem)explorerItem;
                iterator.remove();
                printStream.print("->" + e);
                dirExplorerItem = dirExplorerItem2.FindDirectory(collection, printStream);
            } else {
                printStream.print("->" + e + ": not found!");
            }
        } else {
            dirExplorerItem = this;
        }
        return dirExplorerItem;
    }

    public DirExplorerItem FindRootDirectory() {
        DirExplorerItem dirExplorerItem = (DirExplorerItem)this.Items.get(UpperLevelDirectoryString);
        if (dirExplorerItem == null) {
            return this;
        }
        return dirExplorerItem.FindRootDirectory();
    }

    public void PrintDirectory(PrintStream printStream) {
        Iterator iterator = this.Index.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ExplorerItem explorerItem = (ExplorerItem)this.Items.get(e);
            printStream.println("   " + e + " " + explorerItem.getSyntax());
        }
    }

    public Collection StringToParameters(String string) {
        String string2 = "\"'`";
        String string3 = " ";
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"'`", true);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if ("\"'`".indexOf(string4) != -1) {
                    vector.add(stringTokenizer.nextToken(string4));
                    stringTokenizer.nextToken(" \"'`");
                    continue;
                }
                if (" ".indexOf(string4) != -1) continue;
                vector.add(string4);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return vector;
    }

    public ExplorerItem addItem(DirExplorerItem dirExplorerItem) {
        return this.addItem(dirExplorerItem, -1);
    }

    public ExplorerItem addItem(DirExplorerItem dirExplorerItem, int n) {
        dirExplorerItem.addItem(UpperLevelDirectoryString, this, 0);
        return this.addItem(dirExplorerItem.DirectoryName, dirExplorerItem);
    }

    public ExplorerItem addItem(Object object, ExplorerItem explorerItem) {
        return this.addItem(object, explorerItem, -1);
    }

    public ExplorerItem addItem(Object object, ExplorerItem explorerItem, int n) {
        ExplorerItem explorerItem2 = null;
        try {
            try {
                int n2 = this.Index.indexOf(object);
                if (n2 != -1) {
                    this.Index.remove(n2);
                }
                if (n != -1) {
                    this.Index.add(n, object);
                } else {
                    this.Index.add(object);
                }
                explorerItem2 = this.Items.put(object, explorerItem);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return explorerItem2;
    }

    public ExplorerItem getItem(Object object) {
        Object var2_2 = null;
        try {
            try {
                var2_2 = this.Items.get(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return var2_2;
    }

    public ExplorerItem getItem(Collection collection) {
        Iterator iterator = collection.iterator();
        ExplorerItem explorerItem = null;
        if (iterator.hasNext()) {
            Object e = iterator.next();
            ExplorerItem explorerItem2 = (ExplorerItem)this.Items.get(e);
            System.out.print(String.valueOf(String.valueOf(e)) + "->");
            if (iterator.hasNext()) {
                iterator.remove();
                if (explorerItem2 instanceof DirExplorerItem) {
                    explorerItem = ((DirExplorerItem)explorerItem2).getItem(collection);
                }
            } else {
                explorerItem = explorerItem2;
            }
        }
        return explorerItem;
    }

    public ExplorerItem removeItem(Object object) {
        Object var2_2 = null;
        try {
            try {
                int n = this.Index.indexOf(object);
                if (n != -1) {
                    this.Index.remove(n);
                }
                var2_2 = this.Items.remove(object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                unsupportedOperationException.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return var2_2;
    }

    public String toString() {
        return "Directory: " + this.BuildPath();
    }

    class ChangeDirExplorerItem
    extends ExplorerItem {
        public ChangeDirExplorerItem() {
            super("[/] Directory SubDirectory ...");
        }

        public Object Execute(Collection collection, PrintStream printStream) {
            ChangeDirMessage changeDirMessage = null;
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                DirExplorerItem dirExplorerItem;
                Object e = iterator.next();
                DirExplorerItem dirExplorerItem2 = DirExplorerItem.this;
                if (e.equals("\\") || e.equals(DirExplorerItem.RootDirectoryString)) {
                    iterator.remove();
                    dirExplorerItem2 = DirExplorerItem.this.FindRootDirectory();
                }
                if ((dirExplorerItem = dirExplorerItem2.FindDirectory(collection, printStream)) != null) {
                    changeDirMessage = new ChangeDirMessage(dirExplorerItem);
                } else {
                    printStream.println("Invalid Directory.");
                }
            } else {
                printStream.println("Syntax: cd [/] Directory SubDirectory ...");
            }
            return changeDirMessage;
        }

        public String Help(PrintStream printStream) {
            printStream.println("cd [/] Directory SubDirectory ...");
            printStream.println("   Change directory to the specified path.");
            printStream.println("   Subdirecories are separate by spaces.");
            printStream.println("   The root direcrory is / or \\");
            return this.Syntax;
        }
    }

    class HelpExplorerItem
    extends ExplorerItem {
        public HelpExplorerItem() {
            super("help!");
        }

        public Object Execute(Collection collection, PrintStream printStream) {
            Object object = null;
            if (collection.size() == 0) {
                String string = DirExplorerItem.this.BuildPath();
                Iterator iterator = DirExplorerItem.this.Index.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    printStream.println(String.valueOf(string) + DirExplorerItem.RootDirectoryString + e + ":");
                    ((ExplorerItem)DirExplorerItem.this.Items.get(e)).Help(printStream);
                    printStream.println();
                }
                object = DirExplorerItem.this.Index;
            } else {
                ExplorerItem explorerItem = DirExplorerItem.this.getItem(collection);
                if (explorerItem == null) {
                    printStream.println("> Item " + collection + " not found.");
                } else {
                    explorerItem.Help();
                }
                object = explorerItem;
            }
            return object;
        }

        public String Help(PrintStream printStream) {
            printStream.println("help item path");
            printStream.println("   Prints the help message for the specified item.");
            printStream.println("help");
            printStream.println("   Prints the help message for every item in the current directory.");
            return this.Syntax;
        }
    }

    static class ChangeDirMessage {
        public DirExplorerItem targetDirectory;

        public ChangeDirMessage(DirExplorerItem dirExplorerItem) {
            this.targetDirectory = dirExplorerItem;
        }

        public String toString() {
            return "Change dir to: " + this.targetDirectory;
        }
    }
}

