/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent.mobility;

import SOMA.Environment;
import SOMA.agent.Agent;
import SOMA.agent.AgentWorker;
import SOMA.agent.mobility.AgentPacket;
import SOMA.naming.AgentID;
import SOMA.network.connection.Daemon;
import java.io.Serializable;

public class SavedWorker
implements Serializable {
    public AgentPacket packet;
    public boolean activate = false;

    public SavedWorker(Environment environment, AgentWorker agentWorker) throws AgentWorker.AgentWorkerException {
        if (agentWorker.getStatus() == Daemon.ON) {
            agentWorker.stop();
            this.activate = true;
        } else {
            this.activate = false;
        }
        Object object = agentWorker.getStatus();
        if (object != Daemon.OFF && object != AgentWorker.IDLE && object != AgentWorker.STOPPED) {
            throw new AgentWorker.AgentWorkerException("Cannot save worker: " + agentWorker);
        }
        this.packet = environment.agentManager.packAgent(agentWorker.agent);
    }

    public AgentID restoreWorker(Environment environment) throws AgentWorker.AgentWorkerException {
        AgentID agentID = null;
        Agent agent = this.packet.getAgent(environment);
        if (agent != null) {
            AgentWorker agentWorker = environment.agentManager.createWorker(agent);
            if (this.activate) {
                agentWorker.start();
            }
            agentID = agent.getID();
        } else {
            environment.out.println("SavedWorker: Error starting agent: " + this.packet.getAgentID());
        }
        return agentID;
    }

    public String toString() {
        return "[SavedWorker " + this.packet + " activate?" + this.activate + "]";
    }
}

