/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent.mobility;

import SOMA.Environment;
import SOMA.agent.Agent;
import SOMA.agent.classLoading.AgentClassLoader;
import SOMA.agent.classLoading.AgentInputStream;
import SOMA.agent.classLoading.AgentOutputStream;
import SOMA.agent.mobility.AgentPacket;
import SOMA.naming.AgentID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class BasicAgentPacket
implements AgentPacket {
    private final byte[] packet;
    private final AgentID agentID;
    private final String className;
    private Set classToLoadSet = new TreeSet();

    public BasicAgentPacket(Agent agent) {
        this.agentID = agent.getID();
        this.className = agent.getClass().getName();
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AgentOutputStream agentOutputStream = new AgentOutputStream(byteArrayOutputStream, agent);
            agentOutputStream.writeObject(agent);
            byArray = byteArrayOutputStream.toByteArray();
            this.classToLoadSet = ((AgentClassLoader)agent.getClass().getClassLoader()).getLoadedClassesSet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.packet = byArray;
    }

    public Agent getAgent(Environment environment) {
        AgentClassLoader agentClassLoader = new AgentClassLoader(environment, this.className, this.agentID);
        Object object = null;
        try {
            try {
                Object object2;
                environment.networkManager.startPermanentConnection(this.agentID.getHome());
                Iterator iterator = this.classToLoadSet.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    agentClassLoader.loadClass((String)object2);
                }
                object2 = new ByteArrayInputStream(this.packet);
                AgentInputStream agentInputStream = new AgentInputStream((InputStream)object2, agentClassLoader);
                object = (Agent)agentInputStream.readObject();
            }
            catch (Exception exception) {
                exception.printStackTrace(environment.err);
            }
            Object var5_8 = null;
            environment.networkManager.stopPermanentConnection(this.agentID.getHome());
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            environment.networkManager.stopPermanentConnection(this.agentID.getHome());
            throw throwable;
        }
        if (object != null && !(object.getClass().getClassLoader() instanceof AgentClassLoader)) {
            environment.out.println("******************************************************************");
            environment.out.println("WARNING: SYSTEM class loader: Agent " + object + " LOADED BY " + object.getClass().getClassLoader());
            environment.out.println("Class " + object.getClass().getName() + " is in the CLASSPATH");
            environment.out.println("The agent has the privileges fixed for his CLASSPATH position.");
            environment.out.println("******************************************************************");
        }
        return object;
    }

    public AgentID getAgentID() {
        return this.agentID;
    }

    public String toString() {
        return "[BasicAgentPacket " + this.agentID + ", " + this.className + "]";
    }
}

